# -*- coding: utf-8 -*-
from passport.backend.core.builders.base.faker.fake_builder import BaseFakeBuilder
from passport.backend.core.builders.meltingpot_api import MeltingpotApi


class FakeMeltingpotApi(BaseFakeBuilder):
    def __init__(self):
        super(FakeMeltingpotApi, self).__init__(MeltingpotApi)

        self.set_meltingpot_response_value = self.set_response_value_without_method
        self.set_meltingpot_response_side_effect = self.set_response_side_effect_without_method


def meltingpot_ok_response():
    return {
        'status': 'ok',
    }


def meltingpot_error_database_response():
    return {
        'status': 'error',
        'errors': ['backend.database_failed'],
    }


def meltingpot_exception_unhandled():
    return {
        'status': 'error',
        'errors': ['exception.unhandled'],
    }


def meltingtpot_users_history_response():
    return {
        'status': 'ok',
        'history': [
            {
                'id': 1,
                'uid': 1,
                'service': 'meltingpot',
                'reason': 'reason',
                'status': 1,
                'create_date': 111111,
                'update_date': 111111,
                'detect_date': 111111,
                'group_id': None,
            },
        ],
    }


def meltingpot_ok_add_user_response():
    return {
        'status': 'ok',
        'user_history_id': 'object_id',
    }


def meltingpot_ok_add_user_many_response(uids):
    user_history_ids = dict(zip(map(str, uids), ['object_id'] * len(uids)))
    return {
        'status': 'ok',
        'user_history_ids': user_history_ids,
    }
