# coding: utf-8
from time import time

from mssngr.router.lib.protos import (
    client_pb2,
    message_pb2,
)
from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.messenger_api import MssngrFanoutAPI
from passport.backend.core.builders.messenger_api.serializer import serialize
from six.moves.urllib.parse import urlparse


def _response_build(uid=None, utc_timestamp=None, status=0, error_message=None):
    message = message_pb2.TLastSeenResponse()
    message.Status = status

    if uid is not None and status == 0 and error_message is None:
        lastseeninfo = client_pb2.TLastSeenInfo()
        lastseeninfo.Timestamp = int(utc_timestamp if utc_timestamp is not None else time()) * 10 ** 6
        lastseeninfo.User.Uid = uid
        lastseeninfo.User.Guid = 'guid'

        message.LastSeenInfos.extend([lastseeninfo])

    elif error_message is not None:
        errorinfo = message_pb2.TErrorInfo()
        errorinfo.Message = error_message
        errorinfo.TimeMcs = int(time()) * 10 ** 6
        errorinfo.WorkerId = 123

        message.ErrorInfos.extend([errorinfo])

    return serialize(message)


def messenger_api_response(uid=None, timestamp=None):
    return _response_build(uid, timestamp)


def messenger_api_error_response(error_message='error occurred'):
    return _response_build(status=1, error_message=error_message)


def messenger_api_empty_response():
    return _response_build()


def messenger_api_invalid_response_another_message_type():
    """
        Ответ другого формата
    """
    message = message_pb2.TWhoamiResponse()
    return serialize(message)


def messenger_api_html_response():
    return '<html>some code ...</html>'


class FakeMessengerAPI(BaseFakeBuilder):
    def __init__(self):
        super(FakeMessengerAPI, self).__init__(MssngrFanoutAPI)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        url_path = urlparse(url).path

        if http_method == 'POST' and url_path == '/last_seen':
            return 'check_user_lastseen'
        raise FakeBuilderError('Unknown url: "%s"' % url_path)  # pragma: no cover
