# -*- coding: utf-8 -*-
from __future__ import absolute_import

import json
import logging

from passport.backend.core.logging_utils.helpers import trim_message
from passport.backend.utils.string import smart_unicode
import six


log = logging.getLogger(u'passport.builders.mixins.json_parser')


TYPES_TO_DESERIALIZE = (six.binary_type,) + six.string_types


class JsonParserMixin(object):
    parser_error_class = None
    accept_empty_response = False

    def parse_json(self, raw_response):
        service_name = self.__class__.__name__
        response = raw_response.content
        if not isinstance(response, TYPES_TO_DESERIALIZE):
            return response
        if self.accept_empty_response and not response:
            return

        try:
            response = smart_unicode(response)
        except UnicodeDecodeError:
            raise self.parser_error_class(
                u'Invalid encoding in %s response: "%s"' % (
                    service_name,
                    smart_unicode(trim_message(response), errors='replace'),
                ),
            )

        try:
            return json.loads(response)
        except ValueError:
            log.warning(u'%s returned invalid JSON: %s', service_name, trim_message(response))
            raise self.parser_error_class(u'Invalid JSON in %s response: "%s"' % (service_name, trim_message(response)))
