# -*- coding: utf-8 -*-
from __future__ import absolute_import

import logging

import google.protobuf.message
from passport.backend.core.logging_utils.helpers import trim_message
import six


log = logging.getLogger(u'passport.builders.mixins.protobuf_parser')


class ProtobufParserMixin(object):
    parser_error_class = None
    accept_empty_response = False

    def build_protobuf_parser(self, protobuf_class_instance):
        def _parse(raw_response):
            service_name = self.__class__.__name__
            response = raw_response.content
            if not isinstance(response, (six.text_type, six.binary_type)):
                return response
            if self.accept_empty_response and not response:
                return

            try:
                response = protobuf_class_instance.ParseFromString(response)
            except google.protobuf.message.DecodeError:
                log.warning(u'%s returned invalid protobuf: %s', service_name, trim_message(repr(response)))
                raise self.parser_error_class(u'Invalid protobuf in %s response: "%s"' % (
                    service_name,
                    trim_message(repr(response)),
                ))

            return protobuf_class_instance

        return _parse
