# -*- coding: utf-8 -*-
from __future__ import absolute_import

import logging

from passport.backend.core.logging_utils.helpers import trim_message
from passport.backend.core.xml.xml import (
    XML,
    XMLParser,
    XMLSyntaxError,
)


log = logging.getLogger(u'passport.builders.mixins.xml_parser')


class XmlParserMixin(object):
    parser_error_class = None

    def parse_xml(self, raw_response):
        service_name = self.__class__.__name__
        response = raw_response.content
        try:
            parser = XMLParser(ns_clean=True)
            return XML(response.strip(), parser=parser)
        except XMLSyntaxError:
            response = response.decode(u'utf-8')

            log.warning(
                u'%s returned invalid XML: %s',
                service_name,
                trim_message(response),
            )
            raise self.parser_error_class(
                u'Invalid XML in %s response: "%s"' % (
                    service_name,
                    trim_message(response),
                ),
            )
