# -*- coding: utf-8 -*-
from passport.backend.core.exceptions import BaseCoreError


class BaseMoneyApiError(BaseCoreError):
    """Базовая ошибка"""


class MoneyApiTemporaryError(BaseMoneyApiError):
    """Временная ошибка"""


class MoneyApiPermanentError(BaseMoneyApiError):
    """Постоянная ошибка"""


class MoneyApiUnknownSchemeError(MoneyApiPermanentError):
    """Указано недопустимое значение параметра scheme"""


class MoneyApiUserNotFoundError(MoneyApiPermanentError):
    """Пользователь не существует или не завёл Кошелёк"""


class MoneyApiInvalidResponseError(MoneyApiPermanentError):
    """Ответ невалидного формата"""
