# -*- coding: utf-8 -*-
import json

from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.money_api import (
    MoneyPaymentAuthApi,
    PAYMENT_AUTH_SUCCEEDED_STATUS,
)
from six.moves.urllib.parse import urlparse


TEST_AUTH_CONTEXT_ID = '236b94e4-0000-5000-8000-09d0471e9ee2'
TEST_REDIRECT_URI = 'htps://money.yandex.ru/perform_payment_auth'
TEST_SCOPE_ADDENDUM = json.dumps({'yamoneyTokenId': '236b94e4-0000-5000-8000-09d0471e9ee4'})


class FakeMoneyPaymentAuthApi(BaseFakeBuilder):
    def __init__(self):
        super(FakeMoneyPaymentAuthApi, self).__init__(MoneyPaymentAuthApi)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        url_path = urlparse(url).path

        if url_path.endswith('/v1/context') and http_method == 'GET':
            return 'check_auth_context'
        elif url_path.endswith('/v1/context') and http_method == 'POST':
            return 'create_auth_context'
        raise FakeBuilderError('Unknown url: "%s" or bad method: "%s"' % (url_path, http_method))  # pragma: no cover


def money_payment_api_auth_context_response(status=PAYMENT_AUTH_SUCCEEDED_STATUS, request_id='req_id',
                                            uid=1, client_id='clid', scopes=None):
    scopes = scopes or []
    return json.dumps({
        'status': status,
        'authContextId': TEST_AUTH_CONTEXT_ID,
        'redirectUri': TEST_REDIRECT_URI,
        'scopeAddendum': TEST_SCOPE_ADDENDUM,
        'passportRequestId': request_id,
        'uid': str(uid),
        'clientId': client_id,
        'scope': ' '.join([
            str(scope)
            for scope in scopes
        ]),
    })


def money_payment_api_error_response(error='TechnicalError', **kwargs):
    return json.dumps({
        'error': dict(
            type=error,
            **kwargs
        ),
    })
