# -*- coding: utf-8 -*-
import json

from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.music_api import MusicApi
from six.moves.urllib.parse import urlparse


def music_error_response(error):
    return json.dumps({
        'error': {'name': 'unknown', 'message': error},
    }).encode('utf8')


def music_account_status_response(subscription_info=None, plus_info=None):
    subscription_info = subscription_info or {'canStartTrial': False}
    response_data = {
        'result': {
            'account': {
                'displayName': 'foo',
                'firstName': 'test1',
                'secondName': 'test2',
                'fullName': 'test1 test2',
                'hostedUser': False,
                'now': '2017-09-11T12:09:37+00:00',
                'region': 225,
                'serviceAvailable': True,
                'uid': 123,
            },
            'adDisableable': False,
            'hasOrdersHistory': True,
            'isMobileUser': False,
            'subscription': subscription_info,
        },
        'invocation_info': {},
    }
    if plus_info is not None:
        response_data['result']['plus'] = plus_info
    return json.dumps(response_data).encode('utf8')


class FakeMusicApi(BaseFakeBuilder):
    def __init__(self):
        super(FakeMusicApi, self).__init__(MusicApi)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        parsed = urlparse(url)
        url_path = parsed.path
        if url_path.endswith('account/status'):
            return 'account_status'
        raise FakeBuilderError('Unknown url: "%s" or bad method: "%s"' % (url_path, http_method))  # pragma: no cover
