# -*- coding: utf-8 -*-
from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.oauth import OAuth
from six.moves.urllib.parse import urlparse


class FakeOAuth(BaseFakeBuilder):
    def __init__(self):
        super(FakeOAuth, self).__init__(OAuth)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        url_path = urlparse(url).path
        if http_method == 'POST' and url_path == '/token':
            return '_token'
        elif http_method == 'POST' and url_path == '/api/1/authorization_code/issue':
            return 'issue_authorization_code'
        elif http_method == 'GET' and url_path == '/api/1/device/status':
            return 'device_status'
        elif http_method == 'POST' and url_path == '/api/1/device/revoke':
            return 'revoke_device'
        elif http_method == 'POST' and url_path == '/api/1/device_code/issue':
            return 'issue_device_code'
        elif http_method == 'GET' and url_path == '/api/1/device_code/check':
            return 'check_device_code'
        elif http_method == 'POST' and url_path == '/iface_api/1/device/authorize/submit':
            return 'device_authorize_submit'
        elif http_method == 'POST' and url_path == '/iface_api/1/device/authorize/commit':
            return 'device_authorize_commit'
        raise FakeBuilderError('Unknown url: "%s" or bad method: "%s"' % (url_path, http_method))  # pragma: no cover


def token_response(access_token='1234', expires_in=30):
    response = {
        'token_type': 'bearer',
        'access_token': access_token,
    }
    if expires_in is not None:
        response['expires_in'] = expires_in
    return response


def issue_device_code_response(device_code='device-code', user_code='user-code', verification_url='ver-url', expires_in=30):
    response = {
        'device_code': device_code,
        'user_code': user_code,
        'verification_url': verification_url,
    }
    if expires_in is not None:
        response['expires_in'] = expires_in
    return response


def device_authorize_commit_response():
    # ответ прямиком из документации
    return {
        'status': 'ok',
        'device_name': u'Мой Холодильник',
        'account': {
            'uid': 1,
            'login': 'test-user',
            'display_login': 'Test.user',
            'display_name': u'Вася',
            'default_avatar_id': '0/0-0',
            'is_avatar_empty': True,
        },
        'client': {
            'id': '0d66fca6b5a040aa90340eabd473db19',
            'title': 'Test client',
            'description': 'Client for test',
            'icon': 'http://icon',
            'icon_id': '3374/e0778950ab864f87bc9c49b896f5d1a0-3',
            'icon_url': 'https://avatars.mdst.yandex.net/get-oauth/3374/e0778950ab864f87bc9c49b896f5d1a0-3/normal',
            'homepage': 'http://homepage',
            'callback': 'http://callback',
            'scopes': {
                'Test': {
                    'test:foo': {
                        'title': 'Foo',
                        'requires_approval': False,
                        'ttl': None,
                        'is_ttl_refreshable': False,
                    },
                    'test:bar': {
                        'title': 'Foo',
                        'requires_approval': False,
                        'ttl': 120,
                        'is_ttl_refreshable': True,
                    }
                },
                'create_time': 1407477045,
                'is_yandex': False,
            },
        },
    }


def device_authorize_submit_response():
    # ответ прямиком из документации
    return {
        'status': 'ok',
        'device_name': u'Мой Холодильник',
        'require_user_confirm': True,
        'requested_scopes': {
            'Test': {
                'test:foo': {
                    'title': 'Foo',
                    'requires_approval': False,
                    'ttl': None,
                    'is_ttl_refreshable': False,
                },
                'test:bar': {
                    'title': 'Foo',
                    'requires_approval': False,
                    'ttl': 120,
                    'is_ttl_refreshable': True,
                },
            },
        },
        'already_granted_scopes': {},
        'account': {
            'uid': 1,
            'login': 'test-user',
            'display_login': 'Test.user',
            'display_name': u'Вася',
            'default_avatar_id': '0/0-0',
            'is_avatar_empty': True,
        },
        'client': {
            'id': '0d66fca6b5a040aa90340eabd473db19',
            'title': 'Test client',
            'description': 'Client for test',
            'icon': 'http://icon',
            'icon_id': '3374/e0778950ab864f87bc9c49b896f5d1a0-3',
            'icon_url': 'https://avatars.mdst.yandex.net/get-oauth/3374/e0778950ab864f87bc9c49b896f5d1a0-3/normal',
            'homepage': 'http://homepage',
            'callback': 'http://callback',
            'scopes': {
                'Test': {
                    'test:foo': {
                        'title': 'Foo',
                        'requires_approval': False,
                        'ttl': None,
                        'is_ttl_refreshable': False,
                    },
                    'test:bar': {
                        'title': 'Foo',
                        'requires_approval': False,
                        'ttl': 120,
                        'is_ttl_refreshable': True,
                    },
                },
                'create_time': 1407477045,
                'is_yandex': False
            },
        },
    }


def check_device_code_response(uid=1, scopes=None):
    if scopes is None:
        scopes = ['scope-1', 'scope-2']
    response = {
        'uid': uid,
        'scopes': scopes,

    }
    return response


def token_error_response(error='invalid_grant', error_description=''):
    return {
        'error': error,
        'error_description': error_description,
    }


def oauth_bundle_successful_response(**kwargs):
    return dict(
        status='ok',
        **kwargs
    )


def oauth_bundle_error_response(error):
    return dict(
        status='error',
        errors=[error],
    )
