# -*- coding: utf-8 -*-
import json

from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.octopus import Octopus
from passport.backend.utils.string import smart_bytes
from six.moves.urllib.parse import urlparse


TEST_PHONE_NUMBER = '+79990010101'
TEST_CODE = 327
TEST_CALL_SESSION_ID = '123-qwe'
TEST_STATUS_IN_PROGRESS = 'InProgress'


def octopus_response(session_id='fed-123-qwe'):
    return smart_bytes(session_id)


def octopus_session_log_response(session_id=TEST_CALL_SESSION_ID, status=TEST_STATUS_IN_PROGRESS):
    data = {
        'sessionID': session_id,
        'callerURI': '+79000010101',
        'calleeURI': '+79000020202',
        'status': status,
    }
    return json.dumps(data).encode('utf8')


class FakeOctopus(BaseFakeBuilder):
    def __init__(self):
        super(FakeOctopus, self).__init__(Octopus)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        url_path = urlparse(url).path
        if url_path == '/v0/create-call':
            return 'create_session'
        if url_path == '/v0/create-pinger-call':
            return 'create_flash_call_session'
        if url_path == '/v0/call-status':
            return 'get_session_log'
        raise FakeBuilderError('Unknown url: "%s"' % url_path)  # pragma: no cover
