# -*- coding: utf-8 -*-
from __future__ import absolute_import

from passport.backend.core.exceptions import BaseCoreError


class BasePassportError(BaseCoreError):
    pass


class PassportTemporaryError(BasePassportError):
    """Временная ошибка паспорта - стоит поретраиться"""


class PassportPermanentError(BasePassportError):
    """Пятисотка или иная непредвиденная ошибка"""


class PassportNoSubscriptionError(BasePassportError):
    """Аккаунт не подписан на данный сид"""


class PassportInvalidAccountTypeError(BasePassportError):
    """Аккаунт данного типа не может выполнить данную операцию"""


class PassportTooFrequentChangePasswordError(BasePassportError):
    """Слишком частая отправка на смену пароля"""


class PassportActionNotRequiredError(BasePassportError):
    """Уже выставлен флаг принудительной смены пароля"""


class PassportAccountNotFoundError(BasePassportError):
    """
    Смотри описание ошибки в базовом бандле.
    """


class PassportLoginNotavailableError(BasePassportError):
    """
    Смотри описание ошибки в базовом бандле.
    """


class PassportPhonishCompletionNotStartedError(BasePassportError):
    """
    Смотри описание ошибки в бандле дорегистраций.
    """


class PassportPhonishCompletionOtherStartedError(BasePassportError):
    """
    Смотри описание ошибки в бандле дорегистраций.
    """


class PassportReceiverAccountNotFoundError(BasePassportError):
    """
    Смотри описание ошибки в бандле дорегистраций.
    """


class PassportPhoneOperationExistsError(BasePassportError):
    """
    Пытаемся создать операцию на телефоне, на котором уже есть операция.
    """


class PassportAccountDisabledError(BasePassportError):
    """
    Аккаунт заблокирован
    """


class PassportTrackNotFoundError(BasePassportError):
    """
    Трек с данным id не найден
    """


class PassportTrackInvalidStateError(BasePassportError):
    """
    Трек с данным id в его текущем состоянии неприменим в данном процессе
    """


class PassportUserNotVerifiedError(BasePassportError):
    """
    Пользователь не предоставил данных для верификации
    """


class PassportActionImpossible(BasePassportError):
    """
    Данное действие по какой-то причине не допустимо
    """
