# -*- coding: utf-8 -*-
from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.passport import Passport
from six.moves.urllib.parse import urlparse


def passport_ok_response(**kwargs):
    return dict(
        status='ok',
        **kwargs
    )


def passport_bundle_api_error_response(error):
    return dict(
        status='error',
        errors=[error],
    )


def passport_old_api_error_response(code, message):
    return dict(
        status='error',
        errors=[
            {'code': code, 'message': message},
        ],
    )


class FakePassport(BaseFakeBuilder):
    def __init__(self):
        super(FakePassport, self).__init__(Passport)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        url_path = urlparse(url).path

        if http_method == 'POST' and 'subscription' in url_path:
            return 'subscribe'
        elif http_method == 'DELETE' and 'subscription' in url_path:
            return 'unsubscribe'
        elif http_method == 'POST' and 'password_options' in url_path:
            return 'password_options'
        elif http_method == 'POST' and 'options' in url_path:
            return 'account_options'
        elif http_method == 'POST' and 'create_link' in url_path:
            return 'create_restoration_link'
        elif 'app_passwords/create/send_notifications' in url_path:
            return 'app_password_created_send_notifications'
        elif 'oauth/client/edit/send_notifications' in url_path:
            return 'oauth_client_edited_send_notifications'
        elif 'auth/password/challenge/send_email' in url_path:
            return 'send_challenge_email'
        elif http_method == 'POST' and url_path == '/1/bundle/complete/finish_phonish_completion/':
            return 'finish_phonish_completion'
        elif http_method == 'POST' and url_path == '/1/bundle/complete/finish_phonish_migration/':
            return 'finish_phonish_migration'
        elif 'rfc_otp/enable/' in url_path:
            return 'rfc_2fa_enable'
        elif 'rfc_otp/disable/' in url_path:
            return 'rfc_2fa_disable'
        elif 'rfc_otp/set_check_time/' in url_path:
            return 'rfc_2fa_set_time'
        elif url_path == '/2/bundle/phone/bind_phone_from_phonish_to_portal/':
            return 'bind_phone_from_phonish_to_portal'
        elif url_path == '/1/bundle/takeout/extract/start/':
            return 'takeout_start_extract'
        elif url_path == '/1/bundle/takeout/extract/finish/':
            return 'takeout_finish_extract'
        elif url_path == '/1/bundle/takeout/extract/delete_result/':
            return 'takeout_delete_extract_result'
        elif url_path == '/1/bundle/account/reset/avatar/':
            return 'reset_avatar'
        elif url_path == '/1/bundle/account/reset/display_name/':
            return 'reset_display_name'
        elif url_path == '/1/account/avatars/default/':
            return 'set_default_avatar'
        elif url_path == '/1/bundle/account/phonish/uid_by_phone/':
            return 'get_phonish_uid_by_phone'
        elif url_path == '/1/bundle/account/modification/send_notifications/':
            return 'send_account_modification_notifications'
        raise FakeBuilderError('Unknown url: "%s" or bad method: "%s"' % (url_path, http_method))  # pragma: no cover
