# -*- coding: utf-8 -*-
import json

from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.perimeter_api import PerimeterApi
from six.moves.urllib.parse import urlparse


def perimeter_error_response(error):
    return json.dumps({
        'status': 'error',
        'error': error,
    }).encode('utf8')


def perimeter_recreate_totp_secret_response(secret='ABCDEFGHIJ0123456789'):
    return json.dumps({
        'status': 'ok',
        'secret': secret,
    }).encode('utf8')


class FakePerimeterApi(BaseFakeBuilder):
    def __init__(self):
        super(FakePerimeterApi, self).__init__(PerimeterApi)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        parsed = urlparse(url)
        url_path = parsed.path
        if '/recreate-totp-secret/' in url_path:
            return 'recreate_totp_secret'
        raise FakeBuilderError('Unknown url: "%s" or bad method: "%s"' % (url_path, http_method))  # pragma: no cover
