# -*- coding: utf-8 -*-
from passport.backend.core.exceptions import BaseCoreError


class BasePhoneSquatterError(BaseCoreError):
    pass


class PhoneSquatterTemporaryError(BasePhoneSquatterError):
    pass


class PhoneSquatterPermanentError(BasePhoneSquatterError):
    pass


class PhoneSquatterInvalidResponseError(PhoneSquatterPermanentError):
    pass


class PhoneSquatterPhoneNumberNotTrackedError(PhoneSquatterPermanentError):
    """Указанного номера нет в БД сервиса (номер не стоит на мониторинге)"""


class PhoneSquatterPhoneNumberUntrackableError(PhoneSquatterPermanentError):
    """Указанный номер нельзя поставить на мониторинг"""
