# -*- coding: utf-8 -*-
import json

from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.phone_squatter.phone_squatter import PhoneSquatter
from six.moves.urllib.parse import urlparse


def phone_squatter_get_change_status_response(change_unixtime=0):
    return json.dumps({
        'status': 'ok',
        'change_date': change_unixtime,
    }).encode('utf8')


def phone_squatter_start_tracking_response(status='TRACKING_STARTED', reason='no reason'):
    return json.dumps({
        'status': status,
        'reason': reason,
    }).encode('utf8')


class FakePhoneSquatter(BaseFakeBuilder):
    def __init__(self):
        super(FakePhoneSquatter, self).__init__(PhoneSquatter)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        parsed = urlparse(url)
        url_path = parsed.path
        if '/phone/change/status' in url_path:
            return 'get_change_status'
        elif '/phone/tracking/start' in url_path:
            return 'start_tracking'
        raise FakeBuilderError('Unknown url: "%s" or bad method: "%s"' % (url_path, http_method))  # pragma: no cover
