# -*- coding: utf-8 -*-
from passport.backend.core.exceptions import BaseCoreError


class BasePushApiError(BaseCoreError):
    """ Базовая ошибка Push API"""


class PushApiTemporaryError(BasePushApiError):
    """Внутренняя ошибка"""


class PushApiInvalidResponseError(BasePushApiError):
    """Неправильный ответ сервера"""


class PushApiInvalidRequestError(BasePushApiError):
    """Неправильный запрос"""


class PushApiUnsupportedPlatformError(PushApiInvalidRequestError):
    """Неподдерживаемая платформа"""


class PushApiInvalidTokenError(PushApiInvalidRequestError):
    """Неправильный токен"""


class PushApiForbiddenServiceError(PushApiInvalidRequestError):
    """Неправильный сервис"""


class PushApiInvalidCertError(PushApiInvalidRequestError):
    """Неправильный сертификат"""
