# -*- coding: utf-8 -*-
import json

from passport.backend.core.builders.base.faker.fake_builder import BaseFakeBuilder
from passport.backend.core.builders.push_api import PushApi
from passport.backend.utils.common import noneless_dict
from six.moves.urllib.parse import urlparse


class FakePushApi(BaseFakeBuilder):
    def __init__(self):
        super(FakePushApi, self).__init__(PushApi)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        parsed = urlparse(url)
        path = parsed.path.strip('/')
        if 'unsubscribe' in path:
            return 'unsubscribe'
        elif 'subscribe' in path:
            return 'subscribe'
        elif 'send' in path:
            return 'send'
        elif 'register' in path:
            return 'register'
        if 'list' in path:
            return 'list'


def push_api_subscription_info(
    id_, device='', platform='', uuid='', app='',
    extra='', init_time=None, last_sent=None, client='some_client',
    **kwargs
):
    assert id_ is not None
    result = noneless_dict(
        id=id_,
        client=client,
        session='some_session',
        app=app,
        ttl=3600 * 24 * 30,
        device=device,
        platform=platform,
        uuid=uuid,
        extra=extra,
        filter='',
        init_time=init_time,
        last_sent=last_sent,
    )
    result.update(kwargs)
    return result


def push_api_app_subscription_info(
    id_, uuid, app, platform, device='', extra='', init_time=None,
    last_sent=None, **kwargs
):
    assert uuid is not None
    assert platform is not None
    return push_api_subscription_info(
        id_=id_,
        app=app,
        uuid=uuid,
        platform=platform,
        device=device,
        extra=extra,
        init_time=init_time,
        last_sent=last_sent,
        **kwargs
    )


def push_api_list_response(subscriptions):
    return json.dumps(subscriptions)
