# -*- coding: utf-8 -*-
from passport.backend.core.builders.base.faker.fake_builder import BaseFakeBuilder
from passport.backend.core.builders.sender_api.sender_api import SenderApi
from six.moves.urllib.parse import urlparse


class FakeSenderApi(BaseFakeBuilder):
    def __init__(self):
        super(FakeSenderApi, self).__init__(SenderApi)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        parsed = urlparse(url)
        path = parsed.path.strip('/')
        if 'external/unsubscribe/set' in path:
            return 'set_unsubscriptions'
        elif 'external/unsubscribe/copy' in path:
            return 'copy_unsubscriptions'


def sender_api_reply_ok(**parameters):
    return dict(parameters=parameters, result=dict(status='ok'))


def sender_api_reply_error(error=u'какая-то ошибка', **parameters):
    return dict(parameters=parameters, result=dict(status='error', error=error))
