# -*- coding: utf-8 -*-
from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.shakur import Shakur
from six.moves.urllib.parse import urlparse


def shakur_check_password(sha_prefix):
    return {
        "found": True,
        "passwords":
            [
                {
                    "sha1": "{}POSTFIX1".format(sha_prefix),
                    "source": "haveibeenpwned",
                    "freq": 1,
                },
                {
                    "sha1": "{}POSTFIX2".format(sha_prefix),
                    "source": "haveibeenpwned",
                    "freq": 10,
                },
            ],
    }


def shakur_check_password_no_postfix(sha_password):
    return {
        "found": True,
        "passwords":
            [
                {
                    "sha1": sha_password,
                    "source": "haveibeenpwned",
                    "freq": 1,
                },
            ],
    }


def shakur_check_password_not_found():
    return {
        "found": False,
        "passwords": [],
    }


class FakeShakur(BaseFakeBuilder):
    def __init__(self):
        super(FakeShakur, self).__init__(Shakur)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        parsed = urlparse(url)
        url_path = parsed.path
        query = parsed.query

        if 'checkpassword' in url_path:
            if 'sha1' in query:
                return 'check_password'
        raise FakeBuilderError(u'Unknown url: "%s" or bad method: "%s"' % (url_path, http_method))  # pragma: no cover
