# -*- coding: utf-8 -*-
from passport.backend.core.exceptions import BaseCoreError


class BaseSocialApiError(BaseCoreError):
    """ Базовая ошибка социального API """


class SocialApiTemporaryError(BaseSocialApiError):
    """Внутренняя ошибка"""


class SocialApiRequestError(BaseSocialApiError):
    """ Сетевая ошибка при запросе, или вернулись данные неожиданного формата """


class ProfileNotFoundError(BaseSocialApiError):
    """ Профиль не найден """


class SubscriptionNotFoundError(BaseSocialApiError):
    """ Подписка отсутствует у пользователя """


class SubscriptionAlreadyExistsError(BaseSocialApiError):
    """ Подписка у пользователя уже существует """


class TaskNotFoundError(BaseSocialApiError):
    """Задача не найдена"""
