# -*- coding: utf-8 -*-

from passport.backend.core.validators import (
    Birthday,
    Gender,
    Invalid,
)
from passport.backend.utils.common import remove_none_values


def convert_task_profile(profile):
    """
    Преобразует поля социального профиля в типизированные, а также чистит от
    пустых значений.
    """
    FIELD_TO_CONVERTER = {
        'birthday': Birthday().to_python,
        'gender': Gender().to_python,
    }

    profile = profile.copy()

    for field, converter in FIELD_TO_CONVERTER.items():
        convert_profile_field(profile, field, converter)

    return remove_none_values(profile)


def convert_profile_field(profile, field, converter):
    if field in profile:
        raw_value = profile[field]

        try:
            profile[field] = converter(raw_value)
        except Invalid:
            profile[field] = None

        if profile[field] is None:
            del profile[field]
