# -*- coding: utf-8 -*-
from passport.backend.core.exceptions import BaseCoreError


class BaseSocialBrokerError(BaseCoreError):
    """
    Базовая ошибка социального брокера.
    """


class SocialBrokerTemporaryError(BaseSocialBrokerError):
    """Внутренняя ошибка"""


class SocialBrokerRequestError(BaseSocialBrokerError):
    """
    Сетевая ошибка при запросе, или вернулись данные неожиданного формата.
    """


class SocialBrokerInvalidTokenError(BaseSocialBrokerError):
    """
    Предоставленный токен недействителен.
    """


class SocialBrokerInvalidPkceVerifierError(BaseSocialBrokerError):
    """
    Предоставленный code_verifier для PKCE недействителен.
    """


class SocialBrokerTaskNotFoundError(BaseSocialBrokerError):
    """
    Не найден task с id, равным заданному.
    """


class SocialBrokerInvalidTaskIdError(BaseSocialBrokerError):
    """
    Указан некорректный task_id
    """


class SocialBrokerApplicationUnknownError(BaseSocialBrokerError):
    """
    Указано неизвестное приложение.
    """


class SocialBrokerProviderUnknownError(BaseSocialBrokerError):
    """
    Указан неизвестный социальный провайдер.
    """


class SocialBrokerProfileNotAllowedError(BaseSocialBrokerError):
    """
    Запрещается связывать данные аккаунты
    """
