# -*- coding: utf-8 -*-
import json

from passport.backend.core.builders.base.faker.fake_builder import BaseFakeBuilder
from passport.backend.core.builders.social_api.faker.social_api import task_data_response
from passport.backend.core.builders.social_broker import SocialBroker
from passport.backend.core.test.consts import (
    TEST_UID1,
    TEST_UID2,
)
from six.moves.urllib.parse import urlparse


def social_broker_error_response(code='CommunicationFailedError'):
    return json.dumps({
        'error': {
            'message': 'Some error description',
            'code': code,
        },
    })


def check_pkce_ok_response():
    return json.dumps({
        'status': 'ok',
    })


def social_broker_v2_error_response(error):
    return dict(
        status='error',
        errors=[error],
    )


def bind_phonish_account_by_track_v2_ok_response(
    uid=TEST_UID1,
    old=False,
    phonish_uid=TEST_UID2,
):
    return json.dumps(
        dict(
            uid=int(uid),
            old=bool(old),
            phonish_uid=int(phonish_uid),
            status='ok',
        ),
    )


class FakeSocialBroker(BaseFakeBuilder):
    def __init__(self):
        super(FakeSocialBroker, self).__init__(SocialBroker)

        self.set_social_broker_response_value = self.set_response_value_without_method
        self.set_social_broker_response_side_effect = self.set_response_side_effect_without_method

    @staticmethod
    def get_task_by_token_response(*args, **kwargs):
        return task_data_response(*args, **kwargs)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        parsed_url = urlparse(url)
        if http_method == 'POST' and parsed_url.path == '/brokerapi/task_by_token':
            return 'get_task_by_token'
        elif http_method == 'POST' and parsed_url.path == '/brokerapi/check_pkce':
            return 'check_pkce'
        elif parsed_url.path == '/brokerapi/bind_phonish_account_by_track_v2':
            return 'bind_phonish_account_by_track_v2'
