# -*- coding: utf-8 -*-
from passport.backend.core.exceptions import BaseCoreError


class BaseStaffError(BaseCoreError):
    pass


class StaffTemporaryError(BaseStaffError):
    """Временная ошибка Стаффа - стоит поретраиться"""


class StaffPermanentError(BaseStaffError):
    """Пятисотка или иная непредвиденная ошибка"""


class StaffAuthorizationInvalidError(StaffPermanentError):
    """Протух авторизационный токен"""


class StaffEntityNotFoundError(StaffPermanentError):
    """Не найден объект по заданному запросу"""
