# -*- coding: utf-8 -*-
from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.staff import Staff
from six.moves.urllib.parse import urlparse


def staff_paginated_response(items, page=1, total_pages=1):
    return {
        'page': page,
        'pages': total_pages,
        'result': items,
        'total': len(items),
    }


def staff_get_department_id_response(department_id):
    return {
        'department_group': {
            'department': {
                'id': department_id,
            },
        },
    }


def staff_get_user_info_response(uid=1, login='login', is_robot=False):
    return {
        'uid': uid,
        'login': login,
        'official': {
            'is_robot': is_robot,
        },
    }


class FakeStaff(BaseFakeBuilder):
    def __init__(self):
        super(FakeStaff, self).__init__(Staff)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        parsed = urlparse(url)
        url_path = parsed.path
        query = parsed.query

        if 'persons' in url_path:
            if '_fields=department_group.department.id' in query and '_one=1' in query:
                return 'get_department_id'
            elif 'official.is_dismissed=false' in query:
                return 'get_team'
            elif '_one=1' in query:
                return 'get_user_info'
        elif 'groupmembership' in url_path:
            return 'get_user_groups'
        raise FakeBuilderError(u'Unknown url: "%s" or bad method: "%s"' % (url_path, http_method))  # pragma: no cover
