# -*- coding: utf-8 -*-
from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.suggest import FioSuggest
from six.moves.urllib.parse import urlparse


class FakeFioSuggest(BaseFakeBuilder):
    def __init__(self):
        super(FakeFioSuggest, self).__init__(FioSuggest)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        url = urlparse(url).path
        if http_method == 'POST' and url == '/passport':
            return 'get'
        raise FakeBuilderError('Unknown url: %s or bad method: %s' % (url, http_method))  # pragma: no cover
