# -*- coding: utf-8 -*-
from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.takeout import Takeout
from six.moves.urllib.parse import urlparse


def takeout_ok_response(**kwargs):
    return dict(
        status='ok',
        **kwargs
    )


def takeout_error_response(error):
    return dict(
        status='error',
        error=error,
    )


class FakeTakeout(BaseFakeBuilder):
    def __init__(self):
        super(FakeTakeout, self).__init__(Takeout)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        url_path = urlparse(url).path
        if url_path == '/1/prepare_archive/':
            return 'prepare_archive'
        raise FakeBuilderError('Unknown url: "%s" or bad method: "%s"' % (url_path, http_method))  # pragma: no cover
