# -*- coding: utf-8 -*-
import json

from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.taxi_zalogin import TaxiZalogin
from six.moves.urllib.parse import urlparse


def taxi_zalogin_ok_response():
    return b'{}'


def taxi_zalogin_error_response(code, message):
    return json.dumps({'code': str(code), 'message': message})


class FakeTaxiZalogin(BaseFakeBuilder):
    def __init__(self):
        super(FakeTaxiZalogin, self).__init__(TaxiZalogin)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        url_path = urlparse(url).path
        if url_path == '/v1/uid-notify':
            return 'uid_notify'
        raise FakeBuilderError('Unknown url: "%s" or bad method: "%s"' % (url_path, http_method))  # pragma: no cover
