# -*- coding: utf-8 -*-
from passport.backend.core.exceptions import BaseCoreError


class BaseTensorNetError(BaseCoreError):
    """ Базовая ошибка TensorNet"""


class TensorNetTemporaryError(BaseTensorNetError):
    """Внутренняя ошибка"""


class TensorNetInvalidResponseError(BaseTensorNetError):
    """Ответ невалидного формата"""


class TensorNetMissingFeatureError(BaseTensorNetError):
    """Требуемый фактор не найден во входных данных"""
