# -*- coding: utf-8 -*-
from passport.backend.core.exceptions import BaseCoreError


class BaseTrustError(BaseCoreError):
    pass


class TrustTemporaryError(BaseTrustError):
    """Временная ошибка - стоит поретраиться"""


class TrustPermanentError(BaseTrustError):
    """Пятисотка или иная непредвиденная ошибка"""


class TrustAuthorizationInvalidError(TrustPermanentError):
    """Не передан uid или service_token, неправильный service token"""


class TrustBadDataError(TrustPermanentError):
    """
    Если что-то пошло не так и перед очередным вызовом /verify не было вызова post /bindings в течение
    последних 2,5 минут.
    Если между двумя последовательными /verify прошло более 2,5 мин.
    Не переданы все данные.
    """
