# -*- coding: utf-8 -*-
from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.trust_api import (
    TrustBinding,
    VERIFICATION_STATUS_SUCCESS,
)
from six.moves.urllib.parse import urlparse


TEST_3DS_URL = 'https://trust-test.yandex.ru/web/redirect_3ds?purchase_token=verification_id'


def trust_bind():
    return {
        'uid': '582408766',
        'device_id': 'a85c4e72-cf5b-40bb-941e-1191f290fb05',
        'binding': {
            'type': 'card',
            'id': 'card-x5a699b31f78dba7d27c4f7ab',
            'number': '548673****1243',
            'currency': 'RUB',
            'name': 'Citi card',
            'unverified': True,
            'payment_system': 'visa',
            'card_country': 'USA',
            'card_bank': 'ALFABANK',
            'verification_type_recommended': 'standard2_3ds',
            'verifications': [],
            'expiration_month': '04',
            'expiration_year': '2019',
        },
    }


def trust_verify():
    return {
        'uid': '582408766',
        'binding_id': 'card-x5a699b31f78dba7d27c4f7ab',
        'verification': {
            'id': 'a1dba3b2b31439dc258d859964ce7243',
            'method': 'standard2_3ds',
            'status': 'in_progress',
            'status_code': 'wrong_guess',
            'start_ts': '2018-05-15T20:24:06.785000+03:00',
            'finish_ts': '2018-05-15T20:39:06.785000+03:00',
            'authorize_amount': '2.00',
            'authorize_amount_format': '#.##',
            'authorize_currency': 'USD',
            'authorize_rc': 'not_enough_funds',
            'authorize_rrn': '404437707348',
            '3ds_url': 'http://xxx.yy/',
            'finish_binding_url': 'http://service-xxx.yy/',
            'random_amount_tries_left': 2,
        },
    }


def trust_check_payment(status=VERIFICATION_STATUS_SUCCESS):
    return {
        'amount': '2.00',
        'approval_code': '123456',
        'balance_service_id': 138,
        'card_id': '281c8c72cc21f40d5a8ebd65',
        'cardholder': 'TEST',
        'currency': 'RUB',
        'extended_status_3ds': status,
        'fiscal_is_eligible': 0,
        'fiscal_status': '',
        'force_3ds': 1,
        'is_binding_payment': True,
        'masked_pan': '510510****5100',
        'payment_dt': '2021-09-10T14:05:16.908000',
        'payment_id': '613b661c910d39b908b5ca19',
        'payment_method': 'card',
        'payment_method_full': 'card-x281c8c72cc21f40d5a8ebd65',
        'payment_mode': None,
        'payment_type': 'standard2_3ds',
        'paysys_ready_ts': '2021-09-10T14:05:17.971000',
        'paysys_sent_ts': '2021-09-10T14:05:18.430000',
        'purchase_token': 'eb89bf42b6d3cb2ef51beb19253388e8',
        'redirect_3ds_by_post': False,
        'redirect_3ds_form': {},
        'redirect_3ds_url': TEST_3DS_URL,
        'start_dt': '2021-09-10T14:05:17.667000',
        'status': status,
        'status_desc': 'in progress',
        'terminal_id': 99000110,
        'transaction_id': 'es65cbgt-udp2-cj6s-ctgq-05hlda0efnq1',
        'two_stage': 1,
        'uid': '3000250009',
    }


class FakeTrustBinding(BaseFakeBuilder):
    def __init__(self):
        super(FakeTrustBinding, self).__init__(TrustBinding)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        parsed = urlparse(url)
        url_path = parsed.path

        if 'check_payment' in url_path:
            return 'check_payment'
        elif 'verify' in url_path:
            return 'verify'
        elif 'bindings' in url_path:
            return 'bind'
        raise FakeBuilderError(u'Unknown url: "%s" or bad method: "%s"' % (url_path, http_method))  # pragma: no cover
