# -*- coding: utf-8 -*-
from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.trust_api import TrustPayments
from six.moves.urllib.parse import urlparse


TEST_PURCHASE_TOKEN = '26f27aa3c28b78ec1769f5844ed26c8e'
TEST_3DS_URL = 'https://trust-test.yandex.ru/web/payment?purchase_token=verification_id'
TEST_PAYMETHOD_ID = 'card-x281c8c72cc21f40d5a8ebd65'


def get_payment_methods_response(is_empty=False):
    methods = []
    if not is_empty:
        methods += [
            {
                'account': 'w/d219dc9e-0c84-5c3a-a293-247ed26ed2c0',
                'balance': '50444.98',
                'cached_until_ts': 1639144572.04805,
                'currency': 'RUB',
                'id': 'yandex_account-w/d219dc9e-0c84-5c3a-a293-247ed26ed2c0',
                'payment_method': 'yandex_account',
                'payment_system': None,
                'update_ts': 1639058172.04805,
            },
            {
                'account': '510510****5100',
                'aliases': [TEST_PAYMETHOD_ID],
                'binding_systems': ['trust'],
                'binding_ts': '1633012621.220',
                'card_bank': 'BANK OF HAWAII',
                'card_country': 'USA',
                'card_id': TEST_PAYMETHOD_ID,
                'card_level': '',
                'ebin_tags': [],
                'ebin_tags_version': 2,
                'expiration_month': '07',
                'expiration_year': '2022',
                'expired': False,
                'holder': 'TEST',
                'id': TEST_PAYMETHOD_ID,
                'last_paid': 1,
                'last_paid_ts': 1638505186.649394,
                'last_service_paid': 1,
                'last_service_paid_ts': 1638455208.541243,
                'orig_uid': '4082532518',
                'payment_method': 'card',
                'payment_system': 'MasterCard',
                'recommended_verification_type': 'standard2_3ds',
                'region_id': 225,
                'system': 'MasterCard',
            },
        ]
    return {
        'status': 'success',
        'bound_payment_methods': methods,
    }


def create_basket_response():
    return {
        'status': 'success',
        'purchase_token': TEST_PURCHASE_TOKEN,
    }


def get_basket_status_response(uid=42, paymethod_id=TEST_PAYMETHOD_ID, payment_status='not_started', payment_resp_code=None, with_3ds_url=False,
                               use_new_trust_form=False):
    rv = {
        'amount': '1.00',
        'basket_rows': [
            {
                'amount': '1.00',
                'order_id': '168266079',
                'quantity': '0.00',
            },
        ],
        'card_type': 'MasterCard',
        'currency': 'RUB',
        'orders': [
            {
                'current_amount': [],
                'current_qty': '0.00',
                'order_id': '168266079',
                'order_ts': '1633342274.198',
                'orig_amount': '1.00',
                'paid_amount': '0.00',
                'product_id': '3ds_challenge_payment',
                'product_name': '3DS challenge payment',
                'product_type': 'app',
                'uid': '4082532518',
            },
        ],
        'payment_method': 'card',
        'payment_status': payment_status,
        'payment_timeout': '1200.000',
        'paymethod_id': paymethod_id,
        'paysys_sent_ts': '1633342276.141',
        'purchase_token': TEST_PURCHASE_TOKEN,
        'start_ts': '1633342275.157',
        'status': 'success',
        'uid': str(uid),
        'user_account': '510510****5100',
    }
    if with_3ds_url:
        if use_new_trust_form:
            rv['payment_url'] = TEST_3DS_URL
        else:
            rv['3ds_transaction_info'] = {
                'process_url': TEST_3DS_URL.replace('redirect_3ds', 'process_3ds'),
                'redirect_url': TEST_3DS_URL,
                'status': 'wait_for_result',
            }

    if payment_resp_code:
        rv['payment_resp_code'] = payment_resp_code

    return rv


def start_payment_response(**kwargs):
    return get_basket_status_response(payment_status='started', with_3ds_url=False, **kwargs)


def cancel_payment_response():
    return {
        'status': 'success',
        'status_code': 'payment_is_updated',
    }


class FakeTrustPayments(BaseFakeBuilder):
    def __init__(self):
        super(FakeTrustPayments, self).__init__(TrustPayments)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        parsed = urlparse(url)
        url_path = parsed.path

        if http_method == 'GET' and url_path.endswith('payment-methods'):
            return 'get_payment_methods'
        elif http_method == 'POST' and url_path.endswith('payments'):
            return 'create_basket'
        elif http_method == 'GET' and 'payments' in url_path:
            return 'get_basket_status'
        elif http_method == 'POST' and 'start' in url_path:
            return 'start_payment'
        elif http_method == 'POST' and 'unhold' in url_path:
            return 'cancel_payment'
        raise FakeBuilderError('Unknown url: "%s" or bad method: "%s"' % (url_path, http_method))  # pragma: no cover
