# -*- coding: utf-8 -*-
from passport.backend.core.exceptions import BaseCoreError


class BaseTVMError(BaseCoreError):
    pass


class TVMTemporaryError(BaseTVMError):
    """Временная ошибка TVM - стоит поретраиться"""


class TVMPermanentError(BaseTVMError):
    """Пятисотка или иная непредвиденная ошибка"""


class TVMBadRequestError(TVMPermanentError):
    """Некорректный запрос"""


class TVMBadClientError(TVMPermanentError):
    """Приложение повреждено или неверно настроено"""


class TVMInvalidCredentialsError(TVMPermanentError):
    """Переданные авторизационные данные неверны"""
