# -*- coding: utf-8 -*-
from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.tvm import (
    TVM,
    TVM_STATUS_BAD_REQUEST,
)
from six.moves.urllib.parse import urlparse


def tvm_ok_response(message='ticket'):
    return message


def tvm_error_response(status=TVM_STATUS_BAD_REQUEST, error=None):
    return dict(
        status=status,
        error=error,
        desc='Something went wrong',
    )


class FakeTVM(BaseFakeBuilder):
    def __init__(self):
        super(FakeTVM, self).__init__(TVM)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        url_path = urlparse(url).path

        if http_method == 'POST' and url_path == '/2/verify_ssh' and headers.get('X-Ya-Service-Ticket') is not None:
            return 'verify_ssh'
        raise FakeBuilderError('Unknown url: "%s", method: "%s", header "X-Ya-Service-Ticket": %s' % (
            url_path,
            http_method,
            headers.get('X-Ya-Service-Ticket'),
        ))  # pragma: no cover
