# -*- coding: utf-8 -*-
import base64
import json

from passport.backend.core.builders.base.faker.fake_builder import BaseFakeBuilder
from passport.backend.core.builders.ufo_api import UfoApi
from six.moves.urllib.parse import urlparse


_url_path_to_method_name = {
    '/1/profile/': 'profile',
    '/1/phones/stats/': 'phones_stats',
}

method_names = {method for method in _url_path_to_method_name.values()}


class FakeUfoApi(BaseFakeBuilder):
    def __init__(self):
        super(FakeUfoApi, self).__init__(UfoApi)

    def set_response_value(self, method, response):
        if method not in method_names:
            raise ValueError(
                'Set response value for unknown method: {method}'.format(
                    method=method,
                ),
            )
        super(FakeUfoApi, self).set_response_value(method, response)

    def set_response_side_effect(self, method, side_effect):
        if method not in method_names:
            raise ValueError(
                'Set response side effect for unknown method: {method}'.format(
                    method=method,
                ),
            )
        super(FakeUfoApi, self).set_response_side_effect(
            method,
            side_effect,
        )

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        parsed_url = urlparse(url)
        return _url_path_to_method_name[parsed_url.path]


def ufo_api_profile_response(items=None):
    return items or []


def ufo_api_phones_stats_response(phone, data=None):
    return {
        'phone': phone.digital,
        'data': encode_ufo_data(data if data is not None else {}),
    }


TEST_IP = '5.45.207.254'

TEST_UATRAITS_INFO = {
    'OSFamily': 'Java',
    'BrowserEngine': 'Presto',
    'isBrowser': True,
    'BrowserVersion': '6.5',
    'BrowserName': 'OperaMini',
    'BrowserEngineVersion': '2.8.119',
    'J2ME': True,
    'isMobile': True,
}

TEST_YANDEXUID = '3281059040000000099'


TEST_FRESH_ITEM = {
    'ip': TEST_IP,
    'yandexuid': TEST_YANDEXUID,
    'user_agent_info': TEST_UATRAITS_INFO,
}

TEST_TIMEUUID = 'cb78b616-7f0b-11e5-b8cc-fc7bfc3c8e01'


def encode_ufo_data(data):
    return base64.b64encode(
        json.dumps(data).encode('utf8'),
    ).decode('utf8')


def ufo_api_profile_item(timeuuid=TEST_TIMEUUID, data=TEST_FRESH_ITEM):
    return {
        'id': timeuuid,
        'data': encode_ufo_data(data),
    }
