# -*- coding: utf-8 -*-

from passport.backend.core.exceptions import BaseCoreError


class BaseVideoApiError(BaseCoreError):
    pass


class VideoApiTemporaryError(BaseVideoApiError):
    """Временная ошибка апи - стоит поретраиться"""


class VideoApiPermanentError(BaseVideoApiError):
    """Пятисотка или иная непредвиденная ошибка"""


class VideoApiXmlParseError(BaseVideoApiError):
    """Заменяем ошибку парсера на эту"""


class VideoApiNotFoundError(BaseVideoApiError):
    """Видео не найдено"""


class RequestTooLongError(BaseVideoApiError):
    """Задан слишком длинный поисковый запрос"""
