# -*- coding: utf-8 -*-
from lxml import etree
from lxml.builder import E
from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.video import VideoSearchApi
from six import string_types
from six.moves.urllib.parse import urlparse


def video_info_error_response(error_code=u'22', text=u'Указанный тип поиска не разрешен'):
    page = E.yandexsearch(
        E.response(
            E.error(text, code=error_code),
        ),
    )
    return etree.tostring(page)


def video_empty_response():
    return etree.tostring(E.yandexsearch(E.response()))


def video_info_successful_response(query, data):
    if isinstance(query, string_types):
        query = [query]
    query = '|'.join(map(lambda x: 'url:\"%s\"' % x, query))

    groups = []
    for group in data:
        group_tree = E.group(
            E.doc(
                E.url(group.get('url') or ''),
                E.title(group.get('title') or ''),
                E.passages(
                    E.passage(group.get('description') or ''),
                ),
                E.properties(
                    E.MediaDuration(str(group.get('duration') or '')),
                    E.vhdbin(group['hd']) if group.get('hd') else E.patch('4'),
                    E.videoid(group.get('id') or ''),
                ),
                E(
                    'image-properties',
                    E('thumbnail-link', group.get('thumbnail') or ''),
                    E('thumbnail-width-original', '480'),
                    E('thumbnail-height-original', '360'),
                ),
            ),
        )
        groups.append(group_tree)

    page = E.yandexsearch(
        E.request(
            E.query(query),
        ),
        E.response(
            E.results(
                E.grouping(
                    *groups
                ),
            ),
        ),
    )
    return etree.tostring(page, pretty_print=True)


class FakeVideoSearchApi(BaseFakeBuilder):
    def __init__(self):
        super(FakeVideoSearchApi, self).__init__(VideoSearchApi)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        parsed = urlparse(url)
        url_path = parsed.path
        if url_path == '/search/xml':
            return 'video_info'
        raise FakeBuilderError('Unknown url: "%s" or bad method: "%s"' % (url_path, http_method))  # pragma: no cover
