# -*- coding: utf-8 -*-

from passport.backend.core.exceptions import BaseCoreError


class YaSmsError(BaseCoreError):
    pass


class YaSmsTemporaryError(YaSmsError):
    """Временная ошибка. (Например мигания yasms)"""


class YaSmsAccessDenied(YaSmsError):
    """Недостаточно прав для выполнения операции"""


class YaSmsValueError(YaSmsError):
    """Неверное значение для параметра"""


class YaSmsPhoneNumberValueError(YaSmsValueError):
    """Невалидное значение для телефона"""


class YaSmsCodeLimitError(YaSmsError):
    """Исчерпано количество попыток валидации (много раз ввели не тот код)"""


class YaSmsUserNotFound(YaSmsError):
    """Пользователь не найден"""


class YaSmsDeliveryError(YaSmsError):
    """Ошибка отправки/доставки sms-сообщения"""


class YaSmsAlreadyVerified(YaSmsError):
    """У пользователя уже зарегистрирован этот номер"""


class YaSmsPermanentBlock(YaSmsError):
    """Номер заблокирован оператором"""


class YaSmsTemporaryBlock(YaSmsError):
    """Между отправками кода подтверждения на один и тот же номер должно пройти определённое время"""


class YaSmsLimitExceeded(YaSmsError):
    """Превышен дневной лимит отправки сообщений на телефонный номер"""


class YaSmsNoText(YaSmsError):
    """Не задан текст сообщения"""


class YaSmsUnfinishedOpExists(YaSmsError):
    """Телефон уже добавлен или находится в процессе удаления"""


class YaSmsConfirmedNumberExists(YaSmsError):
    """У аккаунта уже есть подтвержденный телефон, и добавить ещё один нельзя"""


class YaSmsSecureNumberExists(YaSmsError):
    """У аккаунта уже есть защищенный телефон, нельзя добавить еще один не получится"""


class YaSmsSecureNumberNotAllowed(YaSmsError):
    """У аккаунта нет пароля, а значит ему не положено иметь защищенный номер"""


class YaSmsUidLimitExceeded(YaSmsError):
    """Превышено число отправок смс от uid."""


class YaSmsNoSender(YaSmsError):
    """Нет sender."""


class YaSmsBadTsFormat(YaSmsError):
    """Неправильный формат timestamp."""


class YaSmsSyntaxError(YaSmsError):
    """В ответе Я.Смса обнаружена синтаксическая ошибка."""


class YaSmsImpossibleConfirm(YaSmsError):
    """
    Пользователь еще не добавил указанный номер, чтобы подтвердить его

    или

    передан основной номер, который находится в процессе удаления или изменения.
    """


class YaSmsConflictedOperationExists(YaSmsError):
    """
    Означает что уже есть pending-операции, конфликтующие с вызовом, т.е.:
    если есть операция замены, но для другого номера

    или

    если есть операция удаления номера, неважно в карантина она или нет.
    """


__all__ = (
    'YaSmsError',
    'YaSmsTemporaryError',
    'YaSmsAccessDenied',
    'YaSmsValueError',
    'YaSmsPhoneNumberValueError',
    'YaSmsCodeLimitError',
    'YaSmsUserNotFound',
    'YaSmsDeliveryError',
    'YaSmsAlreadyVerified',
    'YaSmsPermanentBlock',
    'YaSmsTemporaryBlock',
    'YaSmsLimitExceeded',
    'YaSmsNoText',
    'YaSmsUnfinishedOpExists',
    'YaSmsConfirmedNumberExists',
    'YaSmsSecureNumberExists',
    'YaSmsSecureNumberNotAllowed',
    'YaSmsUidLimitExceeded',
    'YaSmsNoSender',
    'YaSmsBadTsFormat',
    'YaSmsSyntaxError',
    'YaSmsImpossibleConfirm',
    'YaSmsConflictedOperationExists',
)
