# -*- coding: utf-8 -*-

import re


_extra_symbols_in_phone_number_re = re.compile(u'[-\s()]+')
_first_eight_re = re.compile(u'^8')


def normalize_phone_number(phone_number):
    """
    Нормирует номер телефона совместимо с перловым Я.Смс-ом.

    Возвращает нормированный номер.
    """
    if phone_number:
        phone_number = _extra_symbols_in_phone_number_re.sub(u'', phone_number)
        phone_number = _first_eight_re.sub(u'+7', phone_number)
        if not phone_number.startswith(u'+'):
            phone_number = u'+' + phone_number

    return phone_number


def accept_non_e164_phone_numbers(f):
    """
    Позволяет функциям phone_bindings_history принимать на вход
    ненормализованные телефонные номера.
    """
    def wrapper(phone_numbers):
        normalized_phone_numbers = {
            normalize_phone_number(n): n for n in phone_numbers
        }
        response = f(normalized_phone_numbers)
        history = response[u'history']
        for landmark in history:
            landmark[u'phone'] = normalized_phone_numbers[landmark[u'phone']]
        return response
    return wrapper
