# -*- coding: utf-8 -*-

import mock
from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.ysa_mirror import (
    YsaMirrorAPI,
    YsaMirrorResolution,
)
from six.moves.urllib.parse import urlparse


TEST_YSA_MIRROR_RESOLUTION1 = YsaMirrorResolution.from_base64(
    '''
    CuABEgRnemlwKltjb20ueWFuZGV4Lm1vYmlsZS5hdXRoLnNkay83LjE3LjIuNzE3MDIxODg4ICh1bmtu
    b3duIEFuZHJvaWQgU0RLIGJ1aWx0IGZvciB4ODY7IEFuZHJvaWQgMTApMg4xNzguMTU0LjE2Mi4xMTib
    kgNCDwoJT1NWZXJzaW9uEgIxMEIMCgdpc1RvdWNoEgExQhMKCE9TRmFtaWx5EgdBbmRyb2lkQg4KCWlz
    QnJvd3NlchIBMEINCghpc01vYmlsZRIBMUIUCgZPU05hbWUSCkFuZHJvaWQgMTASxgQIBhgBIAEonAQw
    2KT7ogs4AkABUDxYlApg//8DcAaAAQGKAqEECgITAQoCEwIKAhMDCgLAKwoCwCwKAsypCgLALwoCwDAK
    AsyoCgLAEwoCwBQKAgCcCgIAnQoCAC8KAgA1EgEAGi8KAgAAEikAJwAAJG1vYmlsZXByb3h5LXRlc3Qu
    cGFzc3BvcnQueWFuZGV4Lm5ldBoECgIAFxoHCgL/ARIBABoOCgIAChIIAAYAHQAXABgaCAoCAAsSAgEA
    GvcBCgIAIxLwAWl+1m2R3Rz0gPIk2GN9cLLKU8vEQeBRBSm9wFDaFyYJeM0fJTpLWU+nDfgZOr7yOkrz
    kgF/5R6H2quR79tsUN7vyEgcCPvQlsesEtA923UsPaEf/HqKKVwUK1iuHnLUJjR/h0gaAf7GLoEz4uWZ
    1T763v2iBD/zaMQgLh8NjKpAJrml3dGDUJrDeXWFXudHSKfj6MAc9K1otwTb708o0kedXA8J1x10E+Sg
    wP1IL3qDduG10TRkMLoxNgFIMCIE3dMO11GxjoV0bSGGJVLP/UcG0FtPzx8cjViGYEoExcIq+CddtEWB
    tnigYOv8k53ehRoUCgIAEBIOAAwCaDIIaHR0cC8xLjEaCwoCAAUSBQEAAAAAGhoKAgANEhQAEgQDCAQE
    AQUDCAUFAQgGBgECARosCgIAMxImACQAHQAgbzvn5hHe21dlyfEeOvXQTkUdGM26nv5yp9UG9TltIwsa
    CAoCAC0SAgEBGg8KAgArEgkIAwQDAwMCAwEggQYogwY=
    ''',
)


class FakeYsaMirrorAPI(BaseFakeBuilder):
    def __init__(self):
        super(FakeYsaMirrorAPI, self).__init__(YsaMirrorAPI)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        url_path = urlparse(url).path

        if http_method == 'GET' and url_path == '/_check_client/fingerprint':
            return 'check_client_by_requestid_v2'
        raise FakeBuilderError('Unknown url: "%s"' % url_path)  # pragma: no cover


def ysa_mirror_ok_resolution_response():
    return mock.Mock(
        content=TEST_YSA_MIRROR_RESOLUTION1.to_bytes(),
        headers={'Content-Type': 'application/octet-stream'},
        status_code=200,
    )


def ysa_mirror_no_resolution_response():
    return mock.Mock(
        content=b'',
        headers={'Content-Type': 'application/octet-stream'},
        status_code=206,
    )
