# -*- coding: utf-8 -*-
from mock import Mock
from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.zora import Zora
from passport.backend.utils.string import smart_unicode
import six
from six.moves.urllib.parse import urlparse


def zora_response(content=b'', status_code=200, reason='', headers=None):
    if isinstance(content, six.text_type):
        content = content.encode(u'utf-8')
    return Mock(
        content=content,
        status_code=status_code,
        encoding=u'utf-8',
        headers=headers or {},
        reason=reason,
    )


def _normalize_url(url):
    if url is None:
        return
    url = smart_unicode(url)
    url = url.replace(smart_unicode('https://'), smart_unicode('http://'))
    url = urlparse(url).geturl()
    return url


class FakeZora(BaseFakeBuilder):
    def __init__(self):
        super(FakeZora, self).__init__(Zora)
        self._data = {}

    def set_response_value(self, url, value, *args, **kwargs):
        url = _normalize_url(url)
        if url not in self._data:
            method = 'method_{}'.format(len(self._data))
            self._data[url] = method
        super(FakeZora, self).set_response_value(self._data[url], value, *args, **kwargs)

    def set_response_side_effect(self, url, side_effect):
        url = _normalize_url(url)
        if url not in self._data:
            method = 'method_{}'.format(len(self._data))
            self._data[url] = method
        super(FakeZora, self).set_response_side_effect(self._data[url], side_effect)

    def parse_method_from_request(self, http_method, url, data, headers=None):
        url = _normalize_url(url)

        if url in self._data:
            return self._data[url]
        if None in self._data:
            return self._data[None]

        raise FakeBuilderError('Unknown url: "%s" or bad method: "%s"' % (url, http_method))  # pragma: no cover
