class BaseCache(object):
    def make_key(self, key):
        raise NotImplementedError

    def validate_key(self, key):
        raise NotImplementedError

    def get(self, key, default=None):
        raise NotImplementedError

    def set(self, key, value, timeout=None):
        raise NotImplementedError

    def delete(self, key):
        raise NotImplementedError

    def has_key(self, key):
        return self.get(key) is not None

    def clear(self):
        raise NotImplementedError
