# -*- coding: utf-8 -*-

from difflib import SequenceMatcher


class StringTrigrams(object):
    def __init__(self, s):
        self._padding = '$$'
        self.trigrams = self._split(s)
        self.count = len(self.trigrams)

    def similarity(self, other):
        if self.count == 0 and other.count == 0:
            return 1.0
        if self.count == other.count and self.trigrams == other.trigrams:
            return 1.0
        if min(self.count, other.count) == 0:
            return 0.0
        return SequenceMatcher(None, self.trigrams, other.trigrams).ratio()

    def _split(self, s):
        if not s:
            return []
        s = self._pad(s)
        return [s[i:i + 3] for i in range(len(s) - 2)]

    def _pad(self, s):
        return self._padding + s + self._padding


def trigrams_compare(a, b):
    """
    Сравнение строк по триграммам.
    Возвращает число, показывающее, насколько близки два аргумента. Диапазон результатов —
    от нуля (это значение указывает, что две строки полностью различны) до одного (это значение
    указывает, что две строки идентичны).
    В метод надо передавать unicode или ascii-строку. Бинарная строка в кодировке utf-8
    побъется на триграммы неправильно.
    """
    if a is None or b is None:
        return 0.0
    return round(StringTrigrams(a).similarity(StringTrigrams(b)), 2)
