# -*- coding: utf-8 -*-
from passport.backend.core.compare.equality.xlit_helper import (
    build_equivalents,
    build_replacements,
)


_XLIT_DATA = {
    # Замены русских подстрок на ASCII
    'ru': (
        # Базовые замены для русского алфавита из unidecode
        (u'а', u'a'),
        (u'б', u'b'),
        (u'в', u'v'),
        (u'г', u'g'),
        (u'д', u'd'),
        (u'е', u'e'),
        (u'ё', u'io'),
        (u'ж', u'zh'),
        (u'з', u'z'),
        (u'и', u'i'),
        (u'й', u'i'),
        (u'к', u'k'),
        (u'л', u'l'),
        (u'м', u'm'),
        (u'н', u'n'),
        (u'о', u'o'),
        (u'п', u'p'),
        (u'р', u'r'),
        (u'с', u's'),
        (u'т', u't'),
        (u'у', u'u'),
        (u'ф', u'f'),
        (u'х', u'kh'),
        (u'ц', u'ts'),
        (u'ч', u'ch'),
        (u'ш', u'sh'),
        (u'щ', u'shch'),
        (u'ъ', u'\''),
        (u'ы', u'y'),
        (u'ь', u'\''),
        (u'э', u'e'),
        (u'ю', u'iu'),
        (u'я', u'ia'),

        # Дополнительные замены
        (u'ай', u'y'),
        (u'в', u'w'),
        (u'джей', u'j'),
        (u'е', u'ye'),
        (u'ей', u'a'),
        (u'др', u'der'),
        (u'ий', u'y'),
        (u'ий', u'iy'),
        (u'ий', u'i'),
        (u'ия', u'ia'),
        (u'ия', u'ya'),
        (u'й', u'j'),
        (u'й', u'y'),
        (u'к', u'ck'),
        (u'кс', u'x'),
        (u'ль', u'ly'),
        (u'о', u'o'),  # одинаковое написание
        (u'с', u'c'),  # одинаковое написание
        (u'у', u'y'),  # одинаковое написание
        (u'у', u'oo'),
        (u'х', u'h'),
        (u'х', u'x'),  # одинаковое написание
        (u'ц', u'c'),
        (u'ц', u'z'),
        (u'ц', u'tc'),
        (u'ч', u'tch'),
        (u'ь', u''),
        (u'ы', u'y'),
        (u'ый', u'y'),
        (u'ю', u'u'),
        (u'ю', u'yu'),
        (u'я', u'ay'),
        (u'я', u'ja'),
        (u'я', u'ya'),
        (u'я', u'a'),
    ),
}

XLIT_REPLACEMENTS, XLIT_MAX_ORIG_LEN, XLIT_EMPTY_REPS = build_replacements(_XLIT_DATA)
XLIT_EQUIVALENTS, XLIT_MAX_EQ_LEN = build_equivalents(XLIT_REPLACEMENTS)
