# -*- coding: utf-8 -*-
# noqa
from datetime import (
    datetime,
    timedelta,
)
import socket

from frozendict import frozendict
from passport.backend.core.conf.login_suggester import (  # noqa
    AUTO_CHUNKS_INITIAL_WEIGHT,
    AUTO_CHUNKS_WEIGHT_STEP,
    CONSONANTS,
    CONSONANTS_2,
    EXCLUDE_LOGIN_REGEXP,
    EXCLUDE_NAME_REGEXP,
    FC_REGEXP,
    FEMALE_GENDER,
    FEMALE_SEX_REGEXP,
    FSG_REGEXP,
    FSGV_REGEXP,
    FSL_REGEXP,
    GENDER_TO_CHUNKS_REGEXP,
    INITIAL_WEIGHT,
    LANG_TO_FEMALE_NAMES_FILE,
    LANG_TO_FEMALE_SURNAME_REGEXP,
    LANG_TO_MALE_NAMES_FILE,
    LANG_TO_MALE_SURNAME_REGEXP,
    LANG_TO_TRANSLITERATIONS_FILE,
    LETTER_TO_NUMBER_COMBINATION_LIMIT,
    LETTER_TO_NUMBER_TRANSLITERATION_LIMIT,
    LOGIN_ENDS_WITH_NUMBER_REGEXP,
    LOGIN_SUGGESTIONS_LIMIT,
    MALE_GENDER,
    MALE_SEX_REGEXP,
    MANUAL_CHUNKS_INITIAL_WEIGHT,
    MANUAL_CHUNKS_WEIGHT_STEP,
    MAX_COMBINATIONS,
    MAX_LOGIN_LENGTH,
    MAX_NAME_LENGTH,
    MAX_TRANSLITERATIONS,
    PACK_SIZE,
    RECENT_YEAR_REGEXP,
    REPLACEMENTS_FACTOR_STEP,
    REPLACEMENTS_INITIAL_FACTOR,
    SEPARATOR,
    SUGGEST_SUPPORTED_LANGUAGES,
    SYNONYM_INITIAL_WEIGHT,
    TFSG_REGEXP,
    TFSL_REGEXP,
    UNDEFINED_GENDER,
    VOWELS,
    VOWELS_2,
)
from passport.backend.core.conf.password_blacklist import PASSWORD_BLACKLIST  # noqa
from passport.backend.core.conf.phone_numbers_fakelist import (  # noqa
    INTERNATIONAL_FAKE_PHONE_NUMBER_FORMATS,
    NATIONAL_FAKE_PHONE_NUMBER_FORMATS,
    PHONE_NUMBERS_FAKELIST,
)
from passport.backend.core.conf.phone_numbers_whitelist import (  # noqa
    PHONE_NUMBERS_WHITELIST,
    PHONE_NUMBERS_WHITELIST_DISABLED_RULES,
)
import pytz


# Год основания Яндекса
YANDEX_FOUNDATION_YEAR = 2000

# 24 часа в секундах - для определения интервалов времени (два дня, неделя)
TIMESTAMP_DELTA_ONE_DAY = 24 * 60 * 60

# максимальное время ожидания ответа ЧЯ
BLACKBOX_TIMEOUT = 0.5

# число попыток получить ответ от ЧЯ
BLACKBOX_RETRIES = 1

# поля, запрашиваемые из ЧЯ по умолчанию
BLACKBOX_FIELDS = ()

# запрашивать ли скрытые (требующие отдельного гранта) алиасы
BLACKBOX_GET_HIDDEN_ALIASES = True

# используемая версия метода ЧЯ login
BLACKBOX_LOGIN_DEFAULT_VERSION = 2

# Версии куки в ЧЯ
BLACKBOX_SESSION_VERSION = 3
BLACKBOX_NEW_SESSION_VERSION = BLACKBOX_SESSION_VERSION

# максимальное количество пулов в UserAgent (выставляется по количеству хостов сторонних сервисов, в которые ходим)
USERAGENT_MAX_POOL_SIZE = 100

# использовать ли глобальный кэш ответов днс сервера
USE_GLOBAL_DNS_CACHE = True

# время кэширования DNS
DNS_CLEANING_INTERVAL = 300.0

# время между обновлениями списка грантов
GRANTS_CONFIG_CACHE_TIME = 60
# список вида: [{'grants_dir': <dir>, 'mask': filename.{env_type}.json}, ...]
GRANTS_FILES = []

TVM_KEYRING_CONFIG_NAME = 'passport'
TVM_CREDENTIALS_CACHE_TIME = 60

EXPERIMENTS_CONFIG_NAME = 'passport'
EXPERIMENTS_CONFIG_CACHE_TIME = 60
EXPERIMENTS_CONFIG_DIR = '/var/cache/yandex/passport-api-experiments/'

# префикс потребителя с ip, с которых можно регистрировать тестовые логины
TEST_YANDEX_LOGIN_CONSUMER_PREFIX = 'create_test_yandex_login_'

# полное имя потребителя с ip, для которых не проверяются ip-счетчики
TEST_COUNTERS_ALWAYS_EMPTY_CONSUMER = 'counters_always_empty'

# полное имя потребителя с ip, для которых не проверяются ip-счетчики
TEST_COUNTERS_ALWAYS_FULL_CONSUMER = 'counters_always_full'

# полное имя потребителя с ip, для которых можно передавать user_ip в кастомном хедере X-YProxy-Header-Ip
SUBSTITUTE_USER_IP_CONSUMER = 'mobileproxy_substitute_ip'

# полное имя потребителя с ip, для которых можно передавать consumer_ip в штатном хедере Ya-Consumer-Client-IP
SUBSTITUTE_CONSUMER_IP_CONSUMER = 'allow_ya_consumer_real_ip'

VALIDATION_MAIL_RECENTLY_SENT_COUNTER = 'email_validator:mail_sent'
VALIDATION_MAIL_TOTAL_SENT_COUNTER = 'email_validator:total_sent'

# параметры подключения к БД
DB_DEFAULT_CONNECT_ARGS = frozendict({
    'mysql': frozendict(),
    'sqlite': {},
})

# число попыток выполнения запроса/коннекта
DB_RETRIES = 2

# время, которое ждём, чтобы приступить к следующей попытке
DB_RETRY_TIMEOUT = 1

# количество соединений с БД
DB_POOL_SIZE = 20

# максимальное время жизни соединения
DB_POOL_RECYCLE = 600

# максимальное количество одноразовых соединений при истощении пула
DB_POOL_MAX_OVERFLOW = 50

# Эмулируемые типы треков, удаленные за ненадобностью
DELETED_TRACK_TYPES = ('account', 'social')

# список хостов с идентификаторами
# состоит из namedtuple('host', 'name id')
HOSTS = []

# Список заблокированных хостов
HOSTS_BLACKLIST = [
    '^h\.school-wiki\.yandex\.net$',
    '^yabs\.yandex\.ru$',
    '^(?:\S+\.)?yandex\.net$',
]

HOSTS_WITH_PATHS_BLACKLIST = [
    ('^yandex\.(?:ru|com|com\.tr)$', '^/clck/.*$'),
    ('^yandex\.(?:ru|com|com\.tr)$', '^/count/.*$'),
]


ADDITIONAL_ALLOWED_RETPATH_SCHEMES = set()
ALLOWED_RETPATH_SCHEME_PREFIXES = set()


# Количество попыток хождения в ЧЯ в ручке /ping
BLACKBOX_AVAILABILITY_TEST_RETRIES = 3


# Число попыток запросов/коннектов к редису
REDIS_RETRY_MAX_COUNT = 3
# Таймаут перезапроса в редис
REDIS_RETRY_TIMEOUT = .1


# Количество случайных байт в идентификаторе трека (по умолчанию)
TRACK_RANDOM_BYTES_COUNT = 16
# Время жизни сессии
TRACK_TTL = 60  # в секундах
# ТТЛ, меньше которого считаем трек проэкспайренным
TRACK_TTL_OFFSET = 5  # в секундах
# Количество символов в коротком индентификаторе трека, алфавит base58; с учетом host_id
# соответствует примерно 11 случайным байтам - см. SECTASK-400
SHORT_TRACK_LENGTH = 16

ALLOWED_TRACK_LENGTHS = {
    TRACK_RANDOM_BYTES_COUNT * 2 + 2,
    SHORT_TRACK_LENGTH,
}

# время ожидания ответа от OAuth-а и быстрого OAuth
OAUTH_TIMEOUT = 1
FAST_OAUTH_TIMEOUT = 0.5
# количество попыток запроса к OAuth и быстрого OAuth
OAUTH_RETRIES = 1
FAST_OAUTH_RETRIES = 1

YASMS_SENDER = 'passport'
YASMS_RETRIES = 1
YASMS_TIMEOUT = 1
YASMS_MARK_OPERATION_TTL = 10

PHONE_QUARANTINE_SECONDS = 14 * 24 * 3600  # 14 дней в секундах


# таймаут запроса к серверу капчи
CAPTCHA_TIMEOUT = 1
# количество попыток запроса к серверу капчи
CAPTCHA_RETRIES = 2
# количество разрешенных проверок одной и той же капчи
CAPTCHA_CHECKS = 1


# Неймспейс MDS, где хранятся аватарки
AVATARS_YAPIC_NAMESPACE = 'yapic'


# максимальное время ожидания ответа ФРОДО
FRODO_TIMEOUT = 1
# число попыток получить ответ от ФРОДО
FRODO_RETRIES = 3
# salt для хэширования телефона по md5 перед отправкой во ФО
FRODO_SECRET_SALT = 'frodo-secret-salt'

# Таймаут на перевысылку смс с кодом валидации телефона
SMS_VALIDATION_RESEND_TIMEOUT = 30  # в секундах
# Максимальное количество отсылок смс на регистрацию (трек)
SMS_VALIDATION_MAX_SMS_COUNT = 5
# Максимальное количество попыток проверки кода
SMS_VALIDATION_MAX_CHECKS_COUNT = 4
# Длина кода, отправляемого по СМС
SMS_VALIDATION_CODE_LENGTH = 6

# Страны с увеличенными лимитами на отправку смс
TRUSTED_COUNTRIES = ('ru', 'tr', 'ua', 'by', 'kz')

# Надо ли учитывать счетчики кармы при проверке капчи
REGKARMA_BAD_ENABLED = False
REGKARMA_GOOD_ENABLED = True

# Дефолтные настройки для политик пароля (используются только для тестов)
BASIC_PASSWORD_POLICY_MIN_LENGTH = 6
BASIC_PASSWORD_POLICY_MIN_QUALITY = 15
BASIC_PASSWORD_POLICY_MIDDLE_QUALITY = 40
BASIC_PASSWORD_POLICY_PWDHISTORY_SEARCH_DEPTH = 5

STRONG_PASSWORD_POLICY_MIN_LENGTH = 10
STRONG_PASSWORD_POLICY_MIN_QUALITY = 70
STRONG_PASSWORD_POLICY_MIDDLE_QUALITY = 70
STRONG_PASSWORD_POLICY_PWDHISTORY_SEARCH_DEPTH = 5

SCHOLAR_PASSWORD_POLICY_MIN_LENGTH = 6

# Время кэширования LRandoms
LRANDOMS_CACHE_TIME = 7200
LRANDOMS_EXPIRE_OFFSET = 60


MAIL_SENDMAIL_PATH = '/usr/sbin/sendmail'
# Поля `From` и `Reply to` для исходящих email
MAIL_DEFAULT_FROM_ADDRESS = 'support@passport.yandex.%s'
MAIL_DEFAULT_REPLY_TO = ('', 'support@passport.yandex.%s')

# Определение TLD для полей `From` и `Reply to` для исходящих email
COUNTRY_CODE_TO_MAIL_ADDRESSES_TLD = {
    'am': 'ru',
    'az': 'ru',
    'by': 'ru',
    'ee': 'ru',
    'ge': 'ru',
    'kg': 'ru',
    'kz': 'ru',
    'lt': 'ru',
    'lv': 'ru',
    'md': 'ru',
    'ru': 'ru',
    'tj': 'ru',
    'tm': 'ru',
    'tr': 'com.tr',
    'ua': 'ru',
    'uz': 'ru',
}
MAIL_ADDRESSES_DEFAULT_TLD = 'com'

# Максимальное число привязанных ящиков, на которые отправляем письма в рамках одной операции
MAX_NOTIFICATION_EMAIL_COUNT = 5

# домены для нативных почтовых адресов
NATIVE_EMAIL_DOMAINS = ('yandex.ru', 'yandex.ua', 'yandex.by', 'yandex.kz', 'yandex.com', 'narod.ru', 'ya.ru')

# Технически это домены второго уровня, но используются они как TLD. Будем считать их доменами первого уровня.
COMPLEX_TLDS = ('com.tr', )

# максимальное время ожидания ответа HistoryDBApi
HISTORYDB_API_TIMEOUT = 5

# число попыток получить ответ от HistoryDBApi
HISTORYDB_API_RETRIES = 2

# consumer, используемый при вызовах HistoryDBApi
HISTORYDB_API_CONSUMER = 'passport'

# Использовать ли TVM при вызовах HistoryDBApi
HISTORYDB_API_USE_TVM = False

# путь к файлу геобазы
GEOBASE_LOOKUP_FILE = '/var/cache/geobase/geodata4.bin'
# путь к файлу геобазы, используемому в тестах
GEOBASE_TESTING_LOOKUP_FILE = '/var/cache/passport-test-geodata/geodata4-passport-ipreg.bin'
# путь к файлу ipreg
IPREG_LOOKUP_FILE = '/var/cache/geobase/layout.json'
# путь к файлу ipreg, используемому в тестах
IPREG_TESTING_LOOKUP_FILE = '/var/cache/passport-test-geodata/layout-passport-ipreg.json'

# путь к файлу ipv4_origin
GEOBASE_IPV4_ORIGIN_FILE = '/var/cache/passport-as-data/ipv4_origin'

# путь к файлу ipv6_origin
GEOBASE_IPV6_ORIGIN_FILE = '/var/cache/passport-as-data/ipv6_origin'

# путь к файлу as_name
GEOBASE_AS_NAME_FILE = '/var/cache/passport-as-data/as_name'

# пути к файлам данных uatraits
UATRAITS_BROWSER_FILE = '/usr/share/uatraits/browser.xml'
UATRAITS_PROFILES_FILE = '/usr/share/uatraits/profiles.xml'
UATRAITS_EXTRA_FILE = '/usr/share/uatraits/extra.xml'

# путь к файл lang_detect_data.txt
LANGDETECT_DATA_FILE = '/usr/share/yandex/lang_detect_data.txt'


# корневые сертификаты для https-соединений
SSL_CA_CERT = '/etc/ssl/certs/ca-certificates.crt'


# Профилирование
PROFILE_ENABLED = False
PROFILE_STATS_PATH = '/tmp/passport_api.prof'

# Кешируем fqdn
CURRENT_FQDN = socket.getfqdn()


# Запрещена ли смена пароля, если ФО ответила плохой кармой про пользователя
FORBIDDEN_CHANGE_PASSWORD_WITH_BAD_FRODO_KARMA = False


# Быстрое отключение смс-валидации на принудительной смене пароля.
# Если файл есть, то мы превращаем в тыкву принудительную смену пароля.
DISABLE_CHANGE_PASSWORD_PHONE_EXPERIMENT = False


# Максимальное время последнего ввода пароля,
# для которого мы не просим пользователя переввести пароль
# на модифицирующих операциях
PASSWORD_VERIFICATION_MAX_AGE = 10 * 60  # 10 минут


# Значение поля from для запросов к email-validator
EMAIL_VALIDATOR_SENDER = 'passp'


# Альтернативные домены и соответствующие идентификаторы
ALT_DOMAINS = frozendict({
    'galatasaray.net': 1,
    'kinopoisk.ru': 2,
    'auto.ru': 1120001,
})
# Домены, на которых можно создать алиас при регистрации
ALT_DOMAINS_AVAILABLE_AT_REGISTRATION = ('auto.ru',)

# Кодировка той ФС в которую записываются файлы.
FILE_SYSTEM_ENCODING = 'utf-8'

# Если число привязок номера не превышает
# YASMS_CLEAN_PHONE_NUMBER_BINDINGS_LIMIT, то он чистый.
YASMS_CLEAN_PHONE_NUMBER_BINDINGS_LIMIT = 1

# Список возможных подписок на sid'ы для соц профилей (в тестах патчится, поэтому пустой)
SOCIAL_DEFAULT_SUBSCRIPTION = []

# Страна по умолчанию
DEFAULT_COUNTRY = 'ru'

# Язык по умолчанию
DEFAULT_LANGUAGE = 'ru'

# Без этих атрибутов модель Phones будет работать неправильно.
BLACKBOX_PHONE_ATTRIBUTES = (
    'phones.default',
    'phones.secure',
)

# Дата, начиная с которой было введено понятие защищенного телефона
PHONES_SECURE_SCHEME_ACTIVE_DATETIME = datetime(2013, 9, 26, 14, 30, 0)

KARMA_PREFIX_SPAMMER = 1
KARMA_PREFIX_WASHED_BY_SUPPORT = 2
KARMA_PREFIX_WASHED = 6

OPTIONS_USE_NEW_SERIALIZATION_SCHEME = False

YASMS_ADMIT_PHONE_VALID_PERIOD = timedelta(days=365.25 / 2)

LOGIN_QUARANTINE_PERIOD = 3600 * 24 * 30 * 6

# Максимальное число uid'ов, о которых можно спросить в одном запросе к ЧЯ
BLACKBOX_MAX_UIDS_PER_REQUEST = 100

HINT_ANSWER_MAX_LENGTH = 30

HISTORYDB_LOG_ENCRYPTION_ENABLED = False

HISTORYDB_LOG_ENCRYPTION_KEY_EPOCH_LENGTH = 30 * 24 * 60 * 60

HISTORYDB_LOG_ENCRYPTION_KEY_DIR = '/etc/yandex/historydb-keys'

ALLOW_NONASCII_IN_EMAILS = False

PHONE_CONFIRMATION_SMS_PER_IP_FOR_CONSUMER_COUNTER_FMT = 'sms:ip_and_consumer:%s'

TOP_LEVEL_DOMAINS = [
    u'ru',
    u'com',
    u'net',
    u'москва',
    u'рф',
    u'xn--80adxhks',  # москва
    u'xn--p1ai',  # рф
]

# 1 ретрай, потому что ребята из ydb попросили ждать максимум времени, сколько можем, в одном запросе.
# клиент ydb сам не повторяет попытки соединиться на транспортных проблемах
YDB_RETRIES = 0  # Будет 1 запрос и 0 попыток его повторить
YDB_CONNECTION_TIMEOUT = 1.000
YDB_GET_SESSION_TIMEOUT = 0.150
YDB_TIMEOUT = 0.450
YDB_DEADLINE = 0.750  # таймаут на операцию на стороне сервера, для экономии cpu-квоты
YDB_USE_TVM = False
YDB_TOKEN = 'token-ololoken'
YDB_ENDPOINT = 'ydb-ru-prestable.yandex.net:2135'
YDB_DATABASE = '/ru-prestable/passport-data/prestable/passport-users'
YDB_FAMILY_INVITE_DATABASE = '/ru-prestable/passport-data/prestable/family_invites'
YDB_PROFILE_TABLE = 'profile-testing'
YDB_PROFILE_ENABLED = True
YDB_READ_LIMIT = 51

# На какой процент включено получение профиля из YDB
YDB_PERCENTAGE = 1
# Флажок на то, надо ли использовать в коде профиль из YDB если он подходит по проценту из параметра выше
TRY_USE_YDB = False

TICKET_PARSER2_BLACKBOX_ENV = 'production'


DRIVE_API_URL = 'https://stable.carsharing.yandex.net'
DRIVE_API_TIMEOUT = 0.1
DRIVE_API_RETRIES = 2

# PASSP-37414 Дополнительное ручное обеление/очернение плохого текста, REJECT сильнее APPROVE
CLEAN_WEB_EMERGENCY_APPROVE_CASE = 'emergency_text_auto_good'
CLEAN_WEB_EMERGENCY_REJECT_CASE = 'emergency_text_auto_delete'

CLEAN_WEB_REJECTED_CAUSES = [
    'text_auto_yandex_mentioned',
    'text_auto_obscene',
    'text_auto_porno',
    'text_auto_spam',

    'text_passport_toloka_gov',
    'text_passport_toloka_org',
    'text_passport_toloka_spam',
    'text_passport_toloka_porno',
    'text_passport_toloka_channel',
    'text_passport_toloka_yandex',
    'text_passport_toloka_swearing',
    'text_passport_toloka_law_violation',

    'media_toloka_porno',
    'media_toloka_violence',
    'media_toloka_shock',
    'media_toloka_erotica',

    'media_auto_porno',
    'media_auto_obscene_text',
    # бывают фолсы https://st.yandex-team.ru/CLEANWEB-620#5dc14914701665001de00630
    # 'media_auto_erotica',
    # 'media_auto_shock',

    CLEAN_WEB_EMERGENCY_REJECT_CASE,
]

CLEAN_WEB_APPROVED_CAUSES = [
    'text_passport_toloka_clean_text',
]

SENDER_MAIL_SUBSCRIPTION_SERVICES = []

# Признак, что следует по возможности избегать использования 8-мизначных
# номеров Кот-Д'Ивуара. Можно включить, только когда в Кот-Д'Ивуаре включат
# 10-тизначные телефоны.
IS_IVORY_COAST_8_DIGIT_PHONES_DEPRECATED = True

TIME_ZONE_OFFSET = datetime.now(tz=pytz.timezone('Europe/Moscow')).strftime('%z')
STATBOX_DATETIME_FORMAT = '%Y-%m-%d %H:%M:%S'

LAH_SIGN_SPACE = 'lah'
LAH_SIGN_TTL = timedelta(days=365 * 2)
LAH_SIGN_VERSION = 2
