# -*- coding: utf-8 -*-
import re


LOGIN_SUGGESTIONS_LIMIT = 10

PACK_SIZE = 20

SUGGEST_SUPPORTED_LANGUAGES = ['en', 'ru', 'tr']

LANG_TO_FEMALE_NAMES_FILE = {lang: '' for lang in SUGGEST_SUPPORTED_LANGUAGES}
LANG_TO_MALE_NAMES_FILE = {lang: '' for lang in SUGGEST_SUPPORTED_LANGUAGES}
LANG_TO_TRANSLITERATIONS_FILE = {lang: '' for lang in SUGGEST_SUPPORTED_LANGUAGES}

MALE_SEX_REGEXP = re.compile(u'(?:[оеё]в|[иоы]й|ин)$', re.UNICODE)
FEMALE_SEX_REGEXP = re.compile(u'(?:(?:[оеё]в|ин)а|ая)$', re.UNICODE)

LANG_TO_MALE_SURNAME_REGEXP = {
    'ru': MALE_SEX_REGEXP,
}

LANG_TO_FEMALE_SURNAME_REGEXP = {
    'ru': FEMALE_SEX_REGEXP,
}

SEPARATOR = '.'

INITIAL_WEIGHT = 100

SYNONYM_INITIAL_WEIGHT = 98

MANUAL_CHUNKS_INITIAL_WEIGHT = 100
MANUAL_CHUNKS_WEIGHT_STEP = 2

AUTO_CHUNKS_INITIAL_WEIGHT = 98
AUTO_CHUNKS_WEIGHT_STEP = 2

REPLACEMENTS_INITIAL_FACTOR = 1.0
REPLACEMENTS_FACTOR_STEP = 0.02

FEMALE_GENDER = 'f'
MALE_GENDER = 'm'
UNDEFINED_GENDER = 'u'

MAX_NAME_LENGTH = 20
MAX_LOGIN_LENGTH = 30

EXCLUDE_NAME_REGEXP = re.compile(u'[^-.\w]+', flags=re.U)
EXCLUDE_LOGIN_REGEXP = re.compile(u'[^-.a-z0-9]+')

LOGIN_ENDS_WITH_NUMBER_REGEXP = re.compile(u'(\d+)$')
RECENT_YEAR_REGEXP = re.compile(u'^(19|20)([0-9]{2})$')

MAX_TRANSLITERATIONS = 500
MAX_COMBINATIONS = 500

# Ограничимся топом при замене букв на цифры
LETTER_TO_NUMBER_COMBINATION_LIMIT = 100
# Если больше 6 замен в слове - сокращаем количество вариантов
LETTER_TO_NUMBER_TRANSLITERATION_LIMIT = 100

# С мягким и твердым знаками
VOWELS = u'[аеёиоуьыъэюяәөұүіaeiouy]'
# Без ъ и ь
CONSONANTS = u'[бвгджзйклмнпрстфхцчшщғқңһbcdfghjklmnpqrstvwxz]'

# Без ъ и ь
VOWELS_2 = u'[аеёийоуыэюяәөұүіaeiouy]'
# С ъ и ь и без казахского
CONSONANTS_2 = u'[бвгджзйклмнпрстфхцчшщьъbcdfghjklmnpqrstvwxz]'

# Первый символ
FC_REGEXP = re.compile(u'^(.)')

# Первый слог лениво
FSL_PATTERN = u'^(.*?{vowels}{consonants})(?:{vowels}|.{{2,}})$'.format(
    vowels=VOWELS,
    consonants=CONSONANTS,
)
FSL_REGEXP = re.compile(FSL_PATTERN)

# Первый слог жадно
FSG_PATTERN = u'^(.*?{vowels}{consonants}+)'.format(
    vowels=VOWELS,
    consonants=CONSONANTS,
)
FSG_REGEXP = re.compile(FSG_PATTERN)

# Первые два слога лениво
TFSL_PATTERN = u'^(.*?{vowels}{consonants}+{vowels}{consonants})(?:{vowels}|.{{2,}})$'.format(
    vowels=VOWELS,
    consonants=CONSONANTS,
)
TFSL_REGEXP = re.compile(TFSL_PATTERN)

# Первые два слога жадно
TFSG_PATTERN = u'^(.*?{vowels}{consonants}+{vowels}{consonants}+)'.format(
    vowels=VOWELS,
    consonants=CONSONANTS,
)
TFSG_REGEXP = re.compile(TFSG_PATTERN)

# Первый слог жадно + одна гласная (c другими наборами букв)
FSGV_PATTERN = u'^(.*?{vowels}{consonants}+{vowels})'.format(
    vowels=VOWELS_2,
    consonants=CONSONANTS_2,
)
FSGV_REGEXP = re.compile(FSGV_PATTERN)

GENDER_TO_CHUNKS_REGEXP = {
    FEMALE_GENDER: [
        FC_REGEXP,
        FSL_REGEXP,
        FSGV_REGEXP,
    ],
    MALE_GENDER: [
        FC_REGEXP,
        FSL_REGEXP,
        FSG_REGEXP,
        TFSL_REGEXP,
        TFSG_REGEXP,
    ],
    UNDEFINED_GENDER: [
        FC_REGEXP,
        FSL_REGEXP,
        FSG_REGEXP,
        TFSG_REGEXP,
    ],
}

LOGIN_PREFIXES = ['ya']

LETTER_TO_NUMBER_REPLACEMENTS = {}
LETTER_TO_NUMBER_REPLACEMENTS_KEYS = set()

PREFIX_WEIGHT = 96
