# -*- coding: utf-8 -*-

import re

import phonenumbers


PHONE_NUMBERS_FAKELIST = [
    # Тестовые номера, на которые не высылаются СМС
    [r'^ \+7000 \d{7} $', 'test_fakes'],
]
for rule in PHONE_NUMBERS_FAKELIST:
    rule[0] = re.compile(rule[0], re.VERBOSE)


# Российские правила оформления номеров
INTERNATIONAL_FAKE_PHONE_NUMBER_FORMATS = [
    phonenumbers.NumberFormat(
        pattern='(0\\d{2})(\\d{3})(\\d{2})(\\d{2})',
        format='\\1 \\2-\\3-\\4',
        leading_digits_pattern=['0'],
    ),
]

NATIONAL_FAKE_PHONE_NUMBER_FORMATS = [
    phonenumbers.NumberFormat(
        pattern='(0\\d{2})(\\d{3})(\\d{2})(\\d{2})',
        format='\\1 \\2-\\3-\\4',
        leading_digits_pattern=['0'],
        national_prefix_formatting_rule='8 (\\1)',
        national_prefix_optional_when_formatting=True,
    ),
]
