# -*- coding: utf-8 -*-
import copy

from passport.backend.core.conf import settings
from passport.backend.core.cookies.cookie_lah.container import container_pb2
from passport.backend.core.protobuf import (
    ProtobufList,
    ProtobufSerializableEntry,
)


class AuthHistoryItem(ProtobufSerializableEntry):
    __protobuf__ = container_pb2.AuthHistoryItem

    version = 1
    input_login = u''

    def __repr__(self):
        return '<%s: %r>' % (self.__class__.__name__, self.__dict__)


class AuthHistoryContainer(ProtobufSerializableEntry):
    __protobuf__ = container_pb2.AuthHistoryContainer

    auth_history_items = ProtobufList(AuthHistoryItem)

    def add(self, uid, timestamp, method, input_login=None):
        # Сюда могут приходить уиды в т.ч. из трека (т.е. являющиеся строками)
        uid = int(uid)
        timestamp = int(timestamp)
        matching_item = self.by_uid(uid)
        if matching_item:
            auth_history_item = matching_item
            auth_history_item.timestamp = timestamp
            auth_history_item.method = method or auth_history_item.method
            if input_login:
                auth_history_item.input_login = input_login
        else:
            auth_history_item = AuthHistoryItem(
                uid=uid,
                timestamp=timestamp,
                method=method,
            )
            if input_login:
                auth_history_item.input_login = input_login
            self.auth_history_items.append(auth_history_item)

        self._save(copy.deepcopy(self.auth_history_items))

    def remove(self, uid):
        auth_history_items = [
            auth_history_item
            for auth_history_item in self.auth_history_items
            if auth_history_item.uid != int(uid)
        ]
        self._save(auth_history_items)

    def by_uid(self, uid):
        matching_items = [
            auth_history_item
            for auth_history_item in self.auth_history_items
            if auth_history_item.uid == uid
        ]
        return matching_items[0] if matching_items else None

    @property
    def _max_size(self):
        return settings.COOKIE_LAH_MAX_SIZE

    def _save(self, items):
        self.auth_history_items = copy.deepcopy(self.__class__.auth_history_items)
        self.auth_history_items.from_iterable(
            sorted(items, key=lambda x: x.timestamp)[-self._max_size:],
        )

    def __iter__(self):
        return iter(self.auth_history_items)

    def __repr__(self):
        return '<%s: %r>' % (self.__class__.__name__, list(self.auth_history_items))

    def __nonzero__(self):
        return bool(self.auth_history_items)

    def __len__(self):
        return len(self.auth_history_items)

    def __getitem__(self, key):
        return self.auth_history_items[key]
