# -*- coding: utf-8 -*-
import logging

from passport.backend.core.cookies.cookie_lah.container import AuthHistoryContainer
from passport.backend.core.cookies.cookie_lah.errors import (
    CookieLAHPackError,
    CookieLAHUnpackError,
)
from passport.backend.core.cookies.cookie_lah.wrapper.base import BaseSignedEncryptedCookie


log = logging.getLogger('passport.cookies.lah')


class CookieLAH(BaseSignedEncryptedCookie):
    pack_error = CookieLAHPackError
    unpack_error = CookieLAHUnpackError

    def pack(self, container):
        if not container:
            return ''

        data = container.dump()
        return super(CookieLAH, self).pack(data)

    def unpack(self, cookie):
        container = AuthHistoryContainer()
        if cookie:
            data = super(CookieLAH, self).unpack(cookie)
            container = container.load(data)
        return container


def try_parse_cookie_lah(cookie_value):
    try:
        return CookieLAH().unpack(cookie_value)
    except CookieLAHUnpackError as e:
        log.debug('Failed to parse cookie lah: %s', e)
        return AuthHistoryContainer()
