# -*- coding: utf-8 -*-
import functools
import operator
import sys

import six


#############################################################
# Копипейст функций из werkzeug 0.14.1 (py2) и 0.16.1 (py3) #
#############################################################


PY2 = sys.version_info[0] == 2


text_type = str
range_type = six.moves.range
int_to_byte = chr

if PY2:
    iter_bytes = iter
else:
    int_to_byte = operator.methodcaller("to_bytes", 1, "big")
    iter_bytes = functools.partial(map, int_to_byte)

_identity = lambda x: x
implements_to_string = _identity
fix_tuple_repr = _identity


if PY2:
    def normalize_string_tuple(tup):
        """Normalizes a string tuple to a common type. Following Python 2
        rules, upgrades to unicode are implicit.
        """
        if any(isinstance(x, text_type) for x in tup):
            return tuple(to_unicode(x) for x in tup)
        return tup
else:
    def normalize_string_tuple(tup):
        """Ensures that all types in the tuple are either strings
        or bytes.
        """
        tupiter = iter(tup)
        is_text = isinstance(next(tupiter, None), text_type)
        for arg in tupiter:
            if isinstance(arg, text_type) != is_text:
                raise TypeError(
                    "Cannot mix str and bytes arguments (got %s)" % repr(tup)
                )
        return tup


def to_bytes(x, charset=sys.getdefaultencoding(), errors='strict'):
    if x is None:
        return None
    if isinstance(x, (bytes, bytearray)):
        return bytes(x)
    if isinstance(x, six.text_type):
        return x.encode(charset, errors)
    raise TypeError('Expected bytes, got %r' % x)


def to_native(x, charset=sys.getdefaultencoding(), errors='strict'):
    if x is None or isinstance(x, str):
        return x
    if PY2:
        return x.encode(charset, errors)
    else:
        return x.decode(charset, errors)


def make_literal_wrapper(reference):
    return _identity


def to_unicode(x, charset=sys.getdefaultencoding(), errors='strict',
               allow_none_charset=False):
    if x is None:
        return None
    if not isinstance(x, bytes):
        return text_type(x)
    if charset is None and allow_none_charset:
        return x
    return x.decode(charset, errors)


def try_coerce_native(s):
    """Try to coerce a unicode string to native if possible. Otherwise,
    leave it as unicode.
    """
    try:
        return to_native(s)
    except UnicodeError:
        return s
